/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.casting;

import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods;
import org.apache.flink.table.planner.functions.casting.AbstractExpressionCodeGeneratorCastRule;
import org.apache.flink.table.planner.functions.casting.CastRulePredicate;
import org.apache.flink.table.planner.functions.casting.CastRuleUtils;
import org.apache.flink.table.planner.functions.casting.CodeGeneratorCastRule;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

class DateToTimestampCastRule
extends AbstractExpressionCodeGeneratorCastRule<Number, TimestampData> {
    static final DateToTimestampCastRule INSTANCE = new DateToTimestampCastRule();

    private DateToTimestampCastRule() {
        super(CastRulePredicate.builder().input(LogicalTypeRoot.DATE).target(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE).target(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE).build());
    }

    @Override
    public String generateExpression(CodeGeneratorCastRule.Context context, String inputTerm, LogicalType inputLogicalType, LogicalType targetLogicalType) {
        if (targetLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE)) {
            return CastRuleUtils.staticCall(BuiltInMethods.TIMESTAMP_FROM_EPOCH_MILLIS(), CastRuleUtils.operator(CastRuleUtils.cast("long", inputTerm), "*", 86400000L));
        }
        if (targetLogicalType.is(LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
            return CastRuleUtils.staticCall(BuiltInMethods.DATE_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE(), inputTerm, context.getSessionTimeZoneTerm());
        }
        throw new IllegalArgumentException("This is a bug. Please file an issue.");
    }
}

