/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.operator.queue;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.flink.agents.runtime.operator.queue.KeySegment;
import org.apache.flink.streaming.api.watermark.Watermark;

public class SegmentedQueue {
    private final Deque<KeySegment> segments = new ArrayDeque<KeySegment>();
    private final Deque<Watermark> watermarks = new ArrayDeque<Watermark>();

    public void addKeyToLastSegment(Object key) {
        KeySegment lastSegment = this.segments.isEmpty() ? this.appendNewSegment() : this.segments.getLast();
        lastSegment.incrementKeyReference(key);
    }

    public boolean removeKey(Object key) {
        boolean removed = false;
        for (KeySegment segment : this.segments) {
            if (!segment.hasActiveKey(key)) continue;
            segment.decrementKeyReference(key);
            removed = true;
            break;
        }
        return removed;
    }

    public void addWatermark(Watermark watermark) {
        this.watermarks.addLast(watermark);
        this.appendNewSegment();
    }

    private KeySegment appendNewSegment() {
        KeySegment newSegment = new KeySegment();
        this.segments.addLast(newSegment);
        return newSegment;
    }

    public Watermark popOldestWatermark() {
        if (this.canProcessWatermark()) {
            this.segments.pop();
            return this.watermarks.pop();
        }
        return null;
    }

    private boolean canProcessWatermark() {
        return this.isFirstSegmentEmpty() && !this.watermarks.isEmpty();
    }

    private boolean isFirstSegmentEmpty() {
        return !this.segments.isEmpty() && this.segments.getFirst().isEmpty();
    }

    Deque<KeySegment> getSegments() {
        return this.segments;
    }

    Deque<Watermark> getWatermarks() {
        return this.watermarks;
    }
}

