/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.utils.Utils;

public class NodeApiVersions {
    private final Map<ApiKeys, ApiVersionsResponseData.ApiVersion> supportedVersions = new EnumMap<ApiKeys, ApiVersionsResponseData.ApiVersion>(ApiKeys.class);
    private final List<ApiVersionsResponseData.ApiVersion> unknownApis = new ArrayList<ApiVersionsResponseData.ApiVersion>();
    private final Map<String, SupportedVersionRange> supportedFeatures;
    private final Map<String, Short> finalizedFeatures;
    private final long finalizedFeaturesEpoch;

    public static NodeApiVersions create() {
        return NodeApiVersions.create(Collections.emptyList());
    }

    public static NodeApiVersions create(Collection<ApiVersionsResponseData.ApiVersion> overrides) {
        LinkedList<ApiVersionsResponseData.ApiVersion> apiVersions = new LinkedList<ApiVersionsResponseData.ApiVersion>(overrides);
        for (ApiKeys apiKey : ApiKeys.clientApis()) {
            boolean exists = false;
            for (ApiVersionsResponseData.ApiVersion apiVersion : apiVersions) {
                if (apiVersion.apiKey() != apiKey.id) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            apiVersions.add(ApiVersionsResponse.toApiVersion(apiKey));
        }
        return new NodeApiVersions(apiVersions, Collections.emptyList(), Collections.emptyList(), -1L);
    }

    public static NodeApiVersions create(short apiKey, short minVersion, short maxVersion) {
        return NodeApiVersions.create(Collections.singleton(new ApiVersionsResponseData.ApiVersion().setApiKey(apiKey).setMinVersion(minVersion).setMaxVersion(maxVersion)));
    }

    public NodeApiVersions(Collection<ApiVersionsResponseData.ApiVersion> nodeApiVersions, Collection<ApiVersionsResponseData.SupportedFeatureKey> nodeSupportedFeatures) {
        this(nodeApiVersions, nodeSupportedFeatures, Collections.emptyList(), -1L);
    }

    public NodeApiVersions(Collection<ApiVersionsResponseData.ApiVersion> nodeApiVersions, Collection<ApiVersionsResponseData.SupportedFeatureKey> nodeSupportedFeatures, Collection<ApiVersionsResponseData.FinalizedFeatureKey> nodeFinalizedFeatures, long finalizedFeaturesEpoch) {
        for (ApiVersionsResponseData.ApiVersion nodeApiVersion : nodeApiVersions) {
            if (ApiKeys.hasId(nodeApiVersion.apiKey())) {
                ApiKeys nodeApiKey = ApiKeys.forId(nodeApiVersion.apiKey());
                this.supportedVersions.put(nodeApiKey, nodeApiVersion);
                continue;
            }
            this.unknownApis.add(nodeApiVersion);
        }
        HashMap<String, SupportedVersionRange> supportedFeaturesBuilder = new HashMap<String, SupportedVersionRange>();
        for (ApiVersionsResponseData.SupportedFeatureKey supportedFeature : nodeSupportedFeatures) {
            supportedFeaturesBuilder.put(supportedFeature.name(), new SupportedVersionRange(supportedFeature.minVersion(), supportedFeature.maxVersion()));
        }
        this.supportedFeatures = Collections.unmodifiableMap(supportedFeaturesBuilder);
        this.finalizedFeaturesEpoch = finalizedFeaturesEpoch;
        this.finalizedFeatures = new HashMap<String, Short>();
        for (ApiVersionsResponseData.FinalizedFeatureKey finalizedFeature : nodeFinalizedFeatures) {
            this.finalizedFeatures.put(finalizedFeature.name(), finalizedFeature.maxVersionLevel());
        }
    }

    public short latestUsableVersion(ApiKeys apiKey) {
        return this.latestUsableVersion(apiKey, apiKey.oldestVersion(), apiKey.latestVersion());
    }

    public short latestUsableVersion(ApiKeys apiKey, short oldestAllowedVersion, short latestAllowedVersion) {
        if (!this.supportedVersions.containsKey((Object)apiKey)) {
            throw new UnsupportedVersionException("The node does not support " + String.valueOf((Object)apiKey));
        }
        ApiVersionsResponseData.ApiVersion supportedVersion = this.supportedVersions.get((Object)apiKey);
        Optional<ApiVersionsResponseData.ApiVersion> intersectVersion = ApiVersionsResponse.intersect(supportedVersion, new ApiVersionsResponseData.ApiVersion().setApiKey(apiKey.id).setMinVersion(oldestAllowedVersion).setMaxVersion(latestAllowedVersion));
        if (intersectVersion.isPresent()) {
            return intersectVersion.get().maxVersion();
        }
        throw new UnsupportedVersionException("The node does not support " + String.valueOf((Object)apiKey) + " with version in range [" + oldestAllowedVersion + "," + latestAllowedVersion + "]. The supported range is [" + supportedVersion.minVersion() + "," + supportedVersion.maxVersion() + "].");
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean lineBreaks) {
        TreeMap<Short, Object> apiKeysText = new TreeMap<Short, Object>();
        for (ApiVersionsResponseData.ApiVersion supportedVersion : this.supportedVersions.values()) {
            apiKeysText.put(supportedVersion.apiKey(), this.apiVersionToText(supportedVersion));
        }
        for (ApiVersionsResponseData.ApiVersion apiVersion : this.unknownApis) {
            apiKeysText.put(apiVersion.apiKey(), this.apiVersionToText(apiVersion));
        }
        for (ApiKeys apiKey : ApiKeys.clientApis()) {
            if (apiKeysText.containsKey(apiKey.id)) continue;
            String bld = apiKey.name + "(" + apiKey.id + "): UNSUPPORTED";
            apiKeysText.put(apiKey.id, bld);
        }
        String separator = lineBreaks ? ",\n\t" : ", ";
        StringBuilder bld = new StringBuilder();
        bld.append("(");
        if (lineBreaks) {
            bld.append("\n\t");
        }
        bld.append(String.join((CharSequence)separator, apiKeysText.values()));
        if (lineBreaks) {
            bld.append("\n");
        }
        bld.append(")");
        return bld.toString();
    }

    private String apiVersionToText(ApiVersionsResponseData.ApiVersion apiVersion) {
        StringBuilder bld = new StringBuilder();
        ApiKeys apiKey = null;
        if (ApiKeys.hasId(apiVersion.apiKey())) {
            apiKey = ApiKeys.forId(apiVersion.apiKey());
            bld.append(apiKey.name).append("(").append(apiKey.id).append("): ");
        } else {
            bld.append("UNKNOWN(").append(apiVersion.apiKey()).append("): ");
        }
        if (apiVersion.minVersion() == apiVersion.maxVersion()) {
            bld.append(apiVersion.minVersion());
        } else {
            bld.append(apiVersion.minVersion()).append(" to ").append(apiVersion.maxVersion());
        }
        if (apiKey != null) {
            ApiVersionsResponseData.ApiVersion supportedVersion = this.supportedVersions.get((Object)apiKey);
            if (apiKey.latestVersion() < supportedVersion.minVersion()) {
                bld.append(" [unusable: node too new]");
            } else if (supportedVersion.maxVersion() < apiKey.oldestVersion()) {
                bld.append(" [unusable: node too old]");
            } else {
                short latestUsableVersion = Utils.min(apiKey.latestVersion(), supportedVersion.maxVersion());
                bld.append(" [usable: ").append(latestUsableVersion).append("]");
            }
        }
        return bld.toString();
    }

    public ApiVersionsResponseData.ApiVersion apiVersion(ApiKeys apiKey) {
        return this.supportedVersions.get((Object)apiKey);
    }

    public Map<ApiKeys, ApiVersionsResponseData.ApiVersion> allSupportedApiVersions() {
        return this.supportedVersions;
    }

    public Map<String, SupportedVersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public Map<String, Short> finalizedFeatures() {
        return this.finalizedFeatures;
    }

    public long finalizedFeaturesEpoch() {
        return this.finalizedFeaturesEpoch;
    }
}

