/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;

public class SupportedVersionRange {
    private final short minVersion;
    private final short maxVersion;

    public SupportedVersionRange(short minVersion, short maxVersion) {
        if (minVersion < 0 || maxVersion < 0 || maxVersion < minVersion) {
            throw new IllegalArgumentException(String.format("Expected 0 <= minVersion <= maxVersion but received minVersion:%d, maxVersion:%d.", minVersion, maxVersion));
        }
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    public short minVersion() {
        return this.minVersion;
    }

    public short maxVersion() {
        return this.maxVersion;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SupportedVersionRange that = (SupportedVersionRange)other;
        return this.minVersion == that.minVersion && this.maxVersion == that.maxVersion;
    }

    public int hashCode() {
        return Objects.hash(this.minVersion, this.maxVersion);
    }

    public String toString() {
        return String.format("SupportedVersionRange[min_version:%d, max_version:%d]", this.minVersion, this.maxVersion);
    }
}

