/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Internal
public final class EnvironmentProperties {
    private static final char[] DOT_DASH = new char[]{'.', '-'};
    private final EnvironmentProperties delegate;
    private final Map<String, List<String>> cache = new HashMap<String, List<String>>();

    private EnvironmentProperties(EnvironmentProperties delegate) {
        this.delegate = delegate;
    }

    public static EnvironmentProperties of(@NonNull Map<String, List<String>> preComputed) {
        EnvironmentProperties current = new EnvironmentProperties(null);
        current.cache.putAll(preComputed);
        return current;
    }

    @NonNull
    public Map<String, List<String>> asMap() {
        return Collections.unmodifiableMap(this.cache);
    }

    public static EnvironmentProperties fork(EnvironmentProperties delegate) {
        return new EnvironmentProperties(delegate);
    }

    public static EnvironmentProperties empty() {
        return new EnvironmentProperties(null);
    }

    public List<String> findPropertyNamesForEnvironmentVariable(String env) {
        List<String> result;
        if (this.delegate != null && (result = this.delegate.cache.get(env)) != null) {
            return result;
        }
        return this.cache.computeIfAbsent(env, EnvironmentProperties::computePropertiesFor);
    }

    private static List<String> computePropertiesFor(String env) {
        env = env.toLowerCase(Locale.ENGLISH);
        ArrayList<Integer> separatorIndexList = new ArrayList<Integer>();
        char[] propertyArr = env.toCharArray();
        for (int i2 = 0; i2 < propertyArr.length; ++i2) {
            if (propertyArr[i2] != '_') continue;
            separatorIndexList.add(i2);
        }
        if (!separatorIndexList.isEmpty()) {
            int[] separatorIndexes = separatorIndexList.stream().mapToInt(Integer::intValue).toArray();
            int separatorCount = separatorIndexes.length;
            int[] halves = new int[separatorCount];
            byte[] separator = new byte[separatorCount];
            int permutations = (int)Math.pow(2.0, separatorCount);
            for (int i3 = 0; i3 < halves.length; ++i3) {
                int start = i3 == 0 ? permutations : halves[i3 - 1];
                halves[i3] = start / 2;
            }
            String[] properties = new String[permutations];
            for (int i4 = 0; i4 < permutations; ++i4) {
                int round = i4 + 1;
                for (int s = 0; s < separatorCount; ++s) {
                    propertyArr[separatorIndexes[s]] = DOT_DASH[separator[s]];
                    if (round % halves[s] != 0) continue;
                    int n = s;
                    separator[n] = (byte)(separator[n] ^ 1);
                }
                properties[i4] = new String(propertyArr);
            }
            return Arrays.asList(properties);
        }
        return Collections.singletonList(env);
    }
}

