/*
 * Decompiled with CFR 0.152.
 */
package grails.init;

import grails.init.GrailsReleaseType;
import grails.init.GrailsUpdater;
import grails.init.GrailsVersion;
import grails.init.Start;
import grails.proxy.SystemPropertiesAuthenticator;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;

public class GrailsWrapper {
    public GrailsWrapper() {
        Authenticator.setDefault(new SystemPropertiesAuthenticator());
    }

    public void execute(String[] args) throws Exception {
        GrailsVersion preferredGrailsVersion = GrailsVersion.getPreferredGrailsVersion();
        LinkedHashSet<GrailsReleaseType> allowedTypes = GrailsVersion.getAllowedReleaseTypes(preferredGrailsVersion, this);
        GrailsUpdater updater = new GrailsUpdater(allowedTypes, preferredGrailsVersion);
        boolean forceUpdate = args.length > 0 && args[0].trim().equals("update-wrapper");
        boolean updated = false;
        String[] adjustedArgs = args;
        if (forceUpdate || updater.needsUpdating()) {
            String allowTypesString = allowedTypes.stream().map(Enum::name).collect(Collectors.joining(","));
            System.out.printf("Updating Grails wrapper, allowed versions to update to are [%s]...%n", allowTypesString);
            updated = updater.update();
            if (forceUpdate) {
                adjustedArgs = Arrays.copyOfRange(args, 1, args.length);
            }
        }
        if (updated) {
            System.out.println("Updated wrapper to version: " + updater.getSelectedVersion().toString());
        }
        URLClassLoader child = new URLClassLoader(new URL[]{updater.getExecutedJarFile().toURI().toURL()});
        Class<?> classToLoad = Class.forName("org.apache.grails.cli.DelegatingShellApplication", true, child);
        Method main = classToLoad.getMethod("main", String[].class);
        main.invoke(null, new Object[]{adjustedArgs});
    }

    public String getVersion() {
        return Start.class.getPackage().getImplementationVersion();
    }
}

