/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.aot.AutowiredArguments;
import org.springframework.beans.factory.aot.AutowiredElementResolver;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.support.SimpleInstantiationStrategy;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.function.ThrowingBiFunction;
import org.springframework.util.function.ThrowingFunction;
import org.springframework.util.function.ThrowingSupplier;

public final class BeanInstanceSupplier<T>
extends AutowiredElementResolver
implements InstanceSupplier<T> {
    private final ExecutableLookup lookup;
    @Nullable
    private final ThrowingFunction<RegisteredBean, T> generatorWithoutArguments;
    @Nullable
    private final ThrowingBiFunction<RegisteredBean, AutowiredArguments, T> generatorWithArguments;
    @Nullable
    private final String[] shortcutBeanNames;

    private BeanInstanceSupplier(ExecutableLookup lookup, @Nullable ThrowingFunction<RegisteredBean, T> generatorWithoutArguments, @Nullable ThrowingBiFunction<RegisteredBean, AutowiredArguments, T> generatorWithArguments, @Nullable String[] shortcutBeanNames) {
        this.lookup = lookup;
        this.generatorWithoutArguments = generatorWithoutArguments;
        this.generatorWithArguments = generatorWithArguments;
        this.shortcutBeanNames = shortcutBeanNames;
    }

    public static <T> BeanInstanceSupplier<T> forConstructor(Class<?> ... parameterTypes) {
        Assert.notNull(parameterTypes, "'parameterTypes' must not be null");
        Assert.noNullElements((Object[])parameterTypes, "'parameterTypes' must not contain null elements");
        return new BeanInstanceSupplier<T>(new ConstructorLookup(parameterTypes), null, null, null);
    }

    public static <T> BeanInstanceSupplier<T> forFactoryMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        Assert.notNull(declaringClass, "'declaringClass' must not be null");
        Assert.hasText(methodName, "'methodName' must not be empty");
        Assert.notNull(parameterTypes, "'parameterTypes' must not be null");
        Assert.noNullElements((Object[])parameterTypes, "'parameterTypes' must not contain null elements");
        return new BeanInstanceSupplier<T>(new FactoryMethodLookup(declaringClass, methodName, parameterTypes), null, null, null);
    }

    ExecutableLookup getLookup() {
        return this.lookup;
    }

    public BeanInstanceSupplier<T> withGenerator(ThrowingBiFunction<RegisteredBean, AutowiredArguments, T> generator) {
        Assert.notNull(generator, "'generator' must not be null");
        return new BeanInstanceSupplier<T>(this.lookup, null, generator, this.shortcutBeanNames);
    }

    public BeanInstanceSupplier<T> withGenerator(ThrowingFunction<RegisteredBean, T> generator) {
        Assert.notNull(generator, "'generator' must not be null");
        return new BeanInstanceSupplier<T>(this.lookup, generator, null, this.shortcutBeanNames);
    }

    @Deprecated(since="6.0.11", forRemoval=true)
    public BeanInstanceSupplier<T> withGenerator(ThrowingSupplier<T> generator) {
        Assert.notNull(generator, "'generator' must not be null");
        return new BeanInstanceSupplier<Object>(this.lookup, registeredBean -> generator.get(), null, this.shortcutBeanNames);
    }

    @Deprecated(since="6.2", forRemoval=true)
    public BeanInstanceSupplier<T> withShortcuts(String ... beanNames) {
        return this.withShortcut(beanNames);
    }

    public BeanInstanceSupplier<T> withShortcut(String ... beanNames) {
        return new BeanInstanceSupplier<T>(this.lookup, this.generatorWithoutArguments, this.generatorWithArguments, beanNames);
    }

    @Override
    public T get(RegisteredBean registeredBean) {
        Assert.notNull((Object)registeredBean, "'registeredBean' must not be null");
        if (this.generatorWithoutArguments != null) {
            Method executable = this.getFactoryMethodForGenerator();
            return (T)this.invokeBeanSupplier(executable, () -> this.generatorWithoutArguments.apply(registeredBean));
        }
        if (this.generatorWithArguments != null) {
            Method executable = this.getFactoryMethodForGenerator();
            AutowiredArguments arguments = this.resolveArguments(registeredBean, executable != null ? executable : this.lookup.get(registeredBean));
            return (T)this.invokeBeanSupplier(executable, () -> this.generatorWithArguments.apply(registeredBean, arguments));
        }
        Executable executable = this.lookup.get(registeredBean);
        Object[] arguments = this.resolveArguments(registeredBean, executable).toArray();
        return (T)this.invokeBeanSupplier(executable, () -> this.instantiate(registeredBean, executable, arguments));
    }

    @Override
    @Nullable
    public Method getFactoryMethod() {
        ExecutableLookup executableLookup = this.lookup;
        if (executableLookup instanceof FactoryMethodLookup) {
            FactoryMethodLookup factoryMethodLookup = (FactoryMethodLookup)executableLookup;
            return factoryMethodLookup.get();
        }
        return null;
    }

    @Nullable
    private Method getFactoryMethodForGenerator() {
        ExecutableLookup executableLookup = this.lookup;
        if (executableLookup instanceof FactoryMethodLookup) {
            FactoryMethodLookup factoryMethodLookup = (FactoryMethodLookup)executableLookup;
            if (factoryMethodLookup.declaringClass.getName().contains("$$")) {
                return factoryMethodLookup.get();
            }
        }
        return null;
    }

    private T invokeBeanSupplier(@Nullable Executable executable, ThrowingSupplier<T> beanSupplier) {
        if (executable instanceof Method) {
            Method method = (Method)executable;
            return SimpleInstantiationStrategy.instantiateWithFactoryMethod(method, beanSupplier);
        }
        return beanSupplier.get();
    }

    AutowiredArguments resolveArguments(RegisteredBean registeredBean) {
        Assert.notNull((Object)registeredBean, "'registeredBean' must not be null");
        return this.resolveArguments(registeredBean, this.lookup.get(registeredBean));
    }

    private AutowiredArguments resolveArguments(RegisteredBean registeredBean, Executable executable) {
        int startIndex;
        int parameterCount = executable.getParameterCount();
        Object[] resolved = new Object[parameterCount];
        Assert.isTrue(this.shortcutBeanNames == null || this.shortcutBeanNames.length == resolved.length, () -> "'shortcuts' must contain " + resolved.length + " elements");
        ConstructorArgumentValues.ValueHolder[] argumentValues = this.resolveArgumentValues(registeredBean, executable);
        LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(resolved.length * 2);
        for (int i2 = startIndex = executable instanceof Constructor && ClassUtils.isInnerClass((constructor = (Constructor)executable).getDeclaringClass()) ? 1 : 0; i2 < parameterCount; ++i2) {
            String shortcut;
            MethodParameter parameter = this.getMethodParameter(executable, i2);
            DependencyDescriptor descriptor = new DependencyDescriptor(parameter, true);
            String string = shortcut = this.shortcutBeanNames != null ? this.shortcutBeanNames[i2] : null;
            if (shortcut != null) {
                descriptor = new AutowiredElementResolver.ShortcutDependencyDescriptor(descriptor, shortcut);
            }
            ConstructorArgumentValues.ValueHolder argumentValue = argumentValues[i2];
            resolved[i2] = this.resolveAutowiredArgument(registeredBean, descriptor, argumentValue, autowiredBeanNames);
        }
        this.registerDependentBeans(registeredBean.getBeanFactory(), registeredBean.getBeanName(), autowiredBeanNames);
        return AutowiredArguments.of(resolved);
    }

    private MethodParameter getMethodParameter(Executable executable, int index2) {
        if (executable instanceof Constructor) {
            Constructor constructor = (Constructor)executable;
            return new MethodParameter(constructor, index2);
        }
        if (executable instanceof Method) {
            Method method = (Method)executable;
            return new MethodParameter(method, index2);
        }
        throw new IllegalStateException("Unsupported executable: " + executable.getClass().getName());
    }

    private ConstructorArgumentValues.ValueHolder[] resolveArgumentValues(RegisteredBean registeredBean, Executable executable) {
        ConfigurableListableBeanFactory configurableListableBeanFactory;
        Parameter[] parameters = executable.getParameters();
        ConstructorArgumentValues.ValueHolder[] resolved = new ConstructorArgumentValues.ValueHolder[parameters.length];
        RootBeanDefinition beanDefinition = registeredBean.getMergedBeanDefinition();
        if (beanDefinition.hasConstructorArgumentValues() && (configurableListableBeanFactory = registeredBean.getBeanFactory()) instanceof AbstractAutowireCapableBeanFactory) {
            AbstractAutowireCapableBeanFactory beanFactory = (AbstractAutowireCapableBeanFactory)((Object)configurableListableBeanFactory);
            BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(beanFactory, registeredBean.getBeanName(), beanDefinition, beanFactory.getTypeConverter());
            ConstructorArgumentValues values = this.resolveConstructorArguments(valueResolver, beanDefinition.getConstructorArgumentValues());
            HashSet<ConstructorArgumentValues.ValueHolder> usedValueHolders = CollectionUtils.newHashSet(parameters.length);
            for (int i2 = 0; i2 < parameters.length; ++i2) {
                String parameterName;
                Class<?> parameterType = parameters[i2].getType();
                ConstructorArgumentValues.ValueHolder valueHolder = values.getArgumentValue(i2, parameterType, parameterName = parameters[i2].isNamePresent() ? parameters[i2].getName() : null, usedValueHolders);
                if (valueHolder == null) continue;
                resolved[i2] = valueHolder;
                usedValueHolders.add(valueHolder);
            }
        }
        return resolved;
    }

    private ConstructorArgumentValues resolveConstructorArguments(BeanDefinitionValueResolver valueResolver, ConstructorArgumentValues constructorArguments) {
        ConstructorArgumentValues resolvedConstructorArguments = new ConstructorArgumentValues();
        for (Map.Entry<Integer, ConstructorArgumentValues.ValueHolder> entry : constructorArguments.getIndexedArgumentValues().entrySet()) {
            resolvedConstructorArguments.addIndexedArgumentValue((int)entry.getKey(), this.resolveArgumentValue(valueResolver, entry.getValue()));
        }
        for (ConstructorArgumentValues.ValueHolder valueHolder : constructorArguments.getGenericArgumentValues()) {
            resolvedConstructorArguments.addGenericArgumentValue(this.resolveArgumentValue(valueResolver, valueHolder));
        }
        return resolvedConstructorArguments;
    }

    private ConstructorArgumentValues.ValueHolder resolveArgumentValue(BeanDefinitionValueResolver resolver, ConstructorArgumentValues.ValueHolder valueHolder) {
        if (valueHolder.isConverted()) {
            return valueHolder;
        }
        Object value = resolver.resolveValueIfNecessary("constructor argument", valueHolder.getValue());
        ConstructorArgumentValues.ValueHolder resolvedHolder = new ConstructorArgumentValues.ValueHolder(value, valueHolder.getType(), valueHolder.getName());
        resolvedHolder.setSource(valueHolder);
        return resolvedHolder;
    }

    @Nullable
    private Object resolveAutowiredArgument(RegisteredBean registeredBean, DependencyDescriptor descriptor, @Nullable ConstructorArgumentValues.ValueHolder argumentValue, Set<String> autowiredBeanNames) {
        TypeConverter typeConverter = registeredBean.getBeanFactory().getTypeConverter();
        if (argumentValue != null) {
            return argumentValue.isConverted() ? argumentValue.getConvertedValue() : typeConverter.convertIfNecessary(argumentValue.getValue(), descriptor.getDependencyType(), descriptor.getMethodParameter());
        }
        try {
            return registeredBean.resolveAutowiredArgument(descriptor, typeConverter, autowiredBeanNames);
        }
        catch (BeansException ex) {
            throw new UnsatisfiedDependencyException(null, registeredBean.getBeanName(), (InjectionPoint)descriptor, ex);
        }
    }

    private Object instantiate(RegisteredBean registeredBean, Executable executable, Object[] args) {
        if (executable instanceof Constructor) {
            Constructor constructor = (Constructor)executable;
            ConfigurableListableBeanFactory configurableListableBeanFactory = registeredBean.getBeanFactory();
            if (configurableListableBeanFactory instanceof DefaultListableBeanFactory) {
                DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)configurableListableBeanFactory;
                if (registeredBean.getMergedBeanDefinition().hasMethodOverrides()) {
                    return dlbf.getInstantiationStrategy().instantiate(registeredBean.getMergedBeanDefinition(), registeredBean.getBeanName(), registeredBean.getBeanFactory());
                }
            }
            return BeanUtils.instantiateClass(constructor, args);
        }
        if (executable instanceof Method) {
            Method method = (Method)executable;
            Object target = null;
            String factoryBeanName = registeredBean.getMergedBeanDefinition().getFactoryBeanName();
            if (factoryBeanName != null) {
                target = registeredBean.getBeanFactory().getBean(factoryBeanName, method.getDeclaringClass());
            } else if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalStateException("Cannot invoke instance method without factoryBeanName: " + String.valueOf(method));
            }
            try {
                ReflectionUtils.makeAccessible(method);
                return method.invoke(target, args);
            }
            catch (Throwable ex) {
                throw new BeanInstantiationException(method, ex.getMessage(), ex);
            }
        }
        throw new IllegalStateException("Unsupported executable " + executable.getClass().getName());
    }

    private static String toCommaSeparatedNames(Class<?> ... parameterTypes) {
        return Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(", "));
    }

    static abstract class ExecutableLookup {
        ExecutableLookup() {
        }

        abstract Executable get(RegisteredBean var1);
    }

    private static class ConstructorLookup
    extends ExecutableLookup {
        private final Class<?>[] parameterTypes;

        ConstructorLookup(Class<?>[] parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        @Override
        public Executable get(RegisteredBean registeredBean) {
            Class<?> beanClass = registeredBean.getMergedBeanDefinition().getBeanClass();
            try {
                return beanClass.getDeclaredConstructor(this.parameterTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("%s cannot be found on %s".formatted(this, beanClass.getName()), ex);
            }
        }

        public String toString() {
            return "Constructor with parameter types [%s]".formatted(BeanInstanceSupplier.toCommaSeparatedNames(this.parameterTypes));
        }
    }

    private static class FactoryMethodLookup
    extends ExecutableLookup {
        private final Class<?> declaringClass;
        private final String methodName;
        private final Class<?>[] parameterTypes;
        @Nullable
        private volatile Method resolvedMethod;

        FactoryMethodLookup(Class<?> declaringClass, String methodName, Class<?>[] parameterTypes) {
            this.declaringClass = declaringClass;
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        @Override
        public Executable get(RegisteredBean registeredBean) {
            return this.get();
        }

        Method get() {
            Method method = this.resolvedMethod;
            if (method == null) {
                method = ReflectionUtils.findMethod(ClassUtils.getUserClass(this.declaringClass), this.methodName, this.parameterTypes);
                Assert.notNull((Object)method, () -> "%s cannot be found".formatted(this));
                this.resolvedMethod = method;
            }
            return method;
        }

        public String toString() {
            return "Factory method '%s' with parameter types [%s] declared on %s".formatted(this.methodName, BeanInstanceSupplier.toCommaSeparatedNames(this.parameterTypes), this.declaringClass);
        }
    }
}

