/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidSnapCountTest
extends ZKTestCase
implements Watcher {
    protected static final Logger LOG = LoggerFactory.getLogger(InvalidSnapCountTest.class);

    @Test
    public void testInvalidSnapCount() throws Exception {
        int CLIENT_PORT = 3181;
        MainThread main = new MainThread(3181);
        main.start();
        Assert.assertTrue((String)"waiting for server being up", (boolean)ClientBase.waitForServerUp("127.0.0.1:3181", ClientBase.CONNECTION_TIMEOUT));
        Assert.assertEquals((long)SyncRequestProcessor.getSnapCount(), (long)2L);
        main.shutdown();
    }

    public void process(WatchedEvent event) {
    }

    public static class TestMain
    extends ZooKeeperServerMain {
        public void shutdown() {
            super.shutdown();
        }
    }

    public static class MainThread
    extends Thread {
        final File confFile;
        final TestMain main;

        public MainThread(int clientPort) throws IOException {
            super("Standalone server with clientPort:" + clientPort);
            File tmpDir = ClientBase.createTmpDir();
            this.confFile = new File(tmpDir, "zoo.cfg");
            FileWriter fwriter = new FileWriter(this.confFile);
            fwriter.write("tickTime=2000\n");
            fwriter.write("initLimit=10\n");
            fwriter.write("syncLimit=5\n");
            fwriter.write("snapCount=1\n");
            File dataDir = new File(tmpDir, "data");
            if (!dataDir.mkdir()) {
                throw new IOException("unable to mkdir " + dataDir);
            }
            String dir = dataDir.toString();
            String osname = System.getProperty("os.name");
            if (osname.toLowerCase().contains("windows")) {
                dir = dir.replace('\\', '/');
            }
            fwriter.write("dataDir=" + dir + "\n");
            fwriter.write("clientPort=" + clientPort + "\n");
            fwriter.flush();
            fwriter.close();
            this.main = new TestMain();
        }

        @Override
        public void run() {
            String[] args = new String[]{this.confFile.toString()};
            try {
                this.main.initializeAndRun(args);
            }
            catch (Exception e) {
                LOG.error("unexpected exception in run", (Throwable)e);
            }
        }

        public void shutdown() {
            this.main.shutdown();
        }
    }
}

