/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.gravitino.authorization.common.AuthorizationProperties;

public class ChainedAuthorizationProperties
extends AuthorizationProperties {
    private static final String PLUGINS_SPLITTER = ",";
    public static final String CHAIN_PLUGINS_PROPERTIES_KEY = "authorization.chain.plugins";
    public static final String CHAIN_PROVIDER = "authorization.chain.*.provider";

    public ChainedAuthorizationProperties(Map<String, String> properties) {
        super(properties);
    }

    @Override
    public String getPropertiesPrefix() {
        return "authorization.chain";
    }

    public String getPluginProvider(String pluginName) {
        return (String)this.properties.get(this.getPropertiesPrefix() + "." + pluginName + ".provider");
    }

    public List<String> plugins() {
        return Arrays.asList(((String)this.properties.get(CHAIN_PLUGINS_PROPERTIES_KEY)).split(PLUGINS_SPLITTER));
    }

    public Map<String, String> fetchAuthPluginProperties(String pluginName) {
        Preconditions.checkArgument((this.properties.containsKey(CHAIN_PLUGINS_PROPERTIES_KEY) && this.properties.get(CHAIN_PLUGINS_PROPERTIES_KEY) != null ? 1 : 0) != 0, (Object)String.format("%s is required", CHAIN_PLUGINS_PROPERTIES_KEY));
        Object[] pluginNames = ((String)this.properties.get(CHAIN_PLUGINS_PROPERTIES_KEY)).split(PLUGINS_SPLITTER);
        Preconditions.checkArgument((boolean)Arrays.asList(pluginNames).contains(pluginName), (Object)String.format("pluginName %s must be one of %s", pluginName, Arrays.toString(pluginNames)));
        String regex = "^authorization\\.chain\\.(" + pluginName + ")\\..*";
        Pattern pattern = Pattern.compile(regex);
        HashMap<String, String> filteredProperties = new HashMap<String, String>();
        for (Map.Entry entry : this.properties.entrySet()) {
            Matcher matcher = pattern.matcher((CharSequence)entry.getKey());
            if (!matcher.matches()) continue;
            filteredProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        String removeRegex = "^authorization\\.chain\\.(" + pluginName + ")\\.";
        Pattern removePattern = Pattern.compile(removeRegex);
        HashMap<String, String> resultProperties = new HashMap<String, String>();
        for (Map.Entry entry : filteredProperties.entrySet()) {
            Matcher removeMatcher = removePattern.matcher((CharSequence)entry.getKey());
            if (!removeMatcher.find()) continue;
            resultProperties.put(removeMatcher.replaceFirst("authorization."), (String)entry.getValue());
        }
        return resultProperties;
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((boolean)this.properties.containsKey(CHAIN_PLUGINS_PROPERTIES_KEY), (Object)String.format("%s is required", CHAIN_PLUGINS_PROPERTIES_KEY));
        List pluginNames = Arrays.stream(((String)this.properties.get(CHAIN_PLUGINS_PROPERTIES_KEY)).split(PLUGINS_SPLITTER)).map(String::trim).filter(v -> !v.isEmpty()).collect(Collectors.toList());
        Preconditions.checkArgument((!pluginNames.isEmpty() ? 1 : 0) != 0, (Object)String.format("%s must have at least one plugin name", CHAIN_PLUGINS_PROPERTIES_KEY));
        Preconditions.checkArgument(((long)pluginNames.size() == pluginNames.stream().distinct().count() ? 1 : 0) != 0, (String)"Duplicate plugin name in %s: %s", (Object)CHAIN_PLUGINS_PROPERTIES_KEY, pluginNames);
        pluginNames.stream().filter(v -> v.contains(".")).forEach(v -> {
            throw new IllegalArgumentException(String.format("Plugin name cannot be contain `.` character in the `%s = %s`.", CHAIN_PLUGINS_PROPERTIES_KEY, this.properties.get(CHAIN_PLUGINS_PROPERTIES_KEY)));
        });
        Pattern pattern = Pattern.compile("^authorization\\.chain\\..*\\..*$");
        Map<String, String> filteredProperties = this.properties.entrySet().stream().filter(entry -> pattern.matcher((CharSequence)entry.getKey()).matches()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String pluginNamesPattern = String.join((CharSequence)"|", pluginNames);
        Pattern patternPluginNames = Pattern.compile("^authorization\\.chain\\.(" + pluginNamesPattern + ")\\..*$");
        for (String key2 : filteredProperties.keySet()) {
            Matcher matcher = patternPluginNames.matcher(key2);
            Preconditions.checkArgument((boolean)matcher.matches(), (String)"The key %s does not match the pattern %s", (Object)key2, (Object)patternPluginNames.pattern());
        }
        ImmutableList wildcardProperties = ImmutableList.of((Object)CHAIN_PROVIDER);
        for (String pluginName : pluginNames) {
            List patterns = wildcardProperties.stream().map(wildcard -> "^" + wildcard.replace("*", pluginName) + "$").map(Pattern::compile).collect(Collectors.toList());
            for (Pattern pattern1 : patterns) {
                boolean matches = filteredProperties.keySet().stream().anyMatch(key -> pattern1.matcher((CharSequence)key).matches());
                Preconditions.checkArgument((boolean)matches, (String)"Missing required properties %s for plugin: %s", filteredProperties, (Object)pattern1.pattern());
            }
        }
    }
}

