/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.authorization.Privilege;

public class AuthorizationRequestContext {
    private final Map<AuthorizationKey, Boolean> allowAuthorizerCache = new ConcurrentHashMap<AuthorizationKey, Boolean>();
    private final Map<AuthorizationKey, Boolean> denyAuthorizerCache = new ConcurrentHashMap<AuthorizationKey, Boolean>();
    private final AtomicBoolean hasLoadRole = new AtomicBoolean();
    private volatile String originalAuthorizationExpression;

    public boolean authorizeAllow(Principal principal, String metalake, MetadataObject metadataObject, Privilege.Name privilege, Function<AuthorizationKey, Boolean> authorizer) {
        AuthorizationKey context = new AuthorizationKey(principal, metalake, metadataObject, privilege);
        return this.allowAuthorizerCache.computeIfAbsent(context, authorizer);
    }

    public boolean authorizeDeny(Principal principal, String metalake, MetadataObject metadataObject, Privilege.Name privilege, Function<AuthorizationKey, Boolean> authorizer) {
        AuthorizationKey context = new AuthorizationKey(principal, metalake, metadataObject, privilege);
        return this.denyAuthorizerCache.computeIfAbsent(context, authorizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRole(Runnable runnable) {
        if (this.hasLoadRole.get()) {
            return;
        }
        AuthorizationRequestContext authorizationRequestContext = this;
        synchronized (authorizationRequestContext) {
            if (this.hasLoadRole.get()) {
                return;
            }
            try {
                runnable.run();
                this.hasLoadRole.set(true);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load role: ", e);
            }
        }
    }

    public String getOriginalAuthorizationExpression() {
        return this.originalAuthorizationExpression;
    }

    public void setOriginalAuthorizationExpression(String originalAuthorizationExpression) {
        this.originalAuthorizationExpression = originalAuthorizationExpression;
    }

    public static class AuthorizationKey {
        private Principal principal;
        private String metalake;
        private MetadataObject metadataObject;
        private Privilege.Name privilege;

        public AuthorizationKey(Principal principal, String metalake, MetadataObject metadataObject, Privilege.Name privilege) {
            this.principal = principal;
            this.metalake = metalake;
            this.metadataObject = metadataObject;
            this.privilege = privilege;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorizationKey)) {
                return false;
            }
            AuthorizationKey that = (AuthorizationKey)o;
            return Objects.equals(this.principal, that.principal) && Objects.equals(this.metalake, that.metalake) && Objects.equals(this.metadataObject, that.metadataObject) && Objects.equals(this.privilege, that.privilege);
        }

        public int hashCode() {
            return Objects.hash(this.principal, this.metalake, this.metadataObject, this.privilege);
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public void setPrincipal(Principal principal) {
            this.principal = principal;
        }

        public String getMetalake() {
            return this.metalake;
        }

        public void setMetalake(String metalake) {
            this.metalake = metalake;
        }

        public MetadataObject getMetadataObject() {
            return this.metadataObject;
        }

        public void setMetadataObject(MetadataObject metadataObject) {
            this.metadataObject = metadataObject;
        }

        public Privilege.Name getPrivilege() {
            return this.privilege;
        }

        public void setPrivilege(Privilege.Name privilege) {
            this.privilege = privilege;
        }
    }
}

