/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.connector;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Schema;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.meta.AuditInfo;

@Evolving
public abstract class BaseSchema
implements Schema {
    protected String name;
    @Nullable
    protected String comment;
    @Nullable
    protected Map<String, String> properties;
    protected AuditInfo auditInfo;

    public String name() {
        return this.name;
    }

    public String comment() {
        return this.comment;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    public String toString() {
        return "BaseSchema(name=" + this.name + ", comment=" + this.comment + ", properties=" + String.valueOf(this.properties) + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
    }

    public static abstract class BaseSchemaBuilder<SELF extends Builder<SELF, T>, T extends BaseSchema>
    implements Builder<SELF, T> {
        protected String name;
        protected String comment;
        protected Map<String, String> properties;
        protected AuditInfo auditInfo;

        @Override
        public SELF withName(String name) {
            this.name = name;
            return this.self();
        }

        @Override
        public SELF withComment(String comment) {
            this.comment = comment;
            return this.self();
        }

        @Override
        public SELF withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this.self();
        }

        @Override
        public SELF withAuditInfo(AuditInfo auditInfo) {
            this.auditInfo = auditInfo;
            return this.self();
        }

        @Override
        public T build() {
            T t = this.internalBuild();
            return t;
        }

        private SELF self() {
            return (SELF)this;
        }

        @Evolving
        protected abstract T internalBuild();
    }

    static interface Builder<SELF extends Builder<SELF, T>, T extends BaseSchema> {
        public SELF withName(String var1);

        public SELF withComment(String var1);

        public SELF withProperties(Map<String, String> var1);

        public SELF withAuditInfo(AuditInfo var1);

        public T build();
    }
}

