/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.metadata;

import java.util.Objects;
import org.apache.paimon.iceberg.metadata.IcebergDataField;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IcebergPartitionField {
    public static final int FIRST_FIELD_ID = 1000;
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TRANSFORM = "transform";
    private static final String FIELD_SOURCE_ID = "source-id";
    private static final String FIELD_FIELD_ID = "field-id";
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="transform")
    private final String transform;
    @JsonProperty(value="source-id")
    private final int sourceId;
    @JsonProperty(value="field-id")
    private final int fieldId;

    public IcebergPartitionField(IcebergDataField dataField, int fieldId) {
        this(dataField.name(), "identity", dataField.id(), fieldId);
    }

    @JsonCreator
    public IcebergPartitionField(@JsonProperty(value="name") String name, @JsonProperty(value="transform") String transform, @JsonProperty(value="source-id") int sourceId, @JsonProperty(value="field-id") int fieldId) {
        this.name = name;
        this.transform = transform;
        this.sourceId = sourceId;
        this.fieldId = fieldId;
    }

    @JsonGetter(value="name")
    public String name() {
        return this.name;
    }

    @JsonGetter(value="transform")
    public String transform() {
        return this.transform;
    }

    @JsonGetter(value="source-id")
    public int sourceId() {
        return this.sourceId;
    }

    @JsonGetter(value="field-id")
    public int fieldId() {
        return this.fieldId;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.transform, this.sourceId, this.fieldId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IcebergPartitionField)) {
            return false;
        }
        IcebergPartitionField that = (IcebergPartitionField)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.transform, that.transform) && this.sourceId == that.sourceId && this.fieldId == that.fieldId;
    }
}

