/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.variants.Serialized;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantUtil;

class SerializedMetadata
implements VariantMetadata,
Serialized {
    private static final int HEADER_SIZE = 1;
    private static final int SUPPORTED_VERSION = 1;
    private static final int VERSION_MASK = 15;
    private static final int SORTED_STRINGS = 16;
    private static final int OFFSET_SIZE_MASK = 192;
    private static final int OFFSET_SIZE_SHIFT = 6;
    static final ByteBuffer EMPTY_V1_BUFFER = ByteBuffer.wrap(new byte[]{1, 0, 0}).order(ByteOrder.LITTLE_ENDIAN);
    static final SerializedMetadata EMPTY_V1_METADATA = SerializedMetadata.from(EMPTY_V1_BUFFER);
    private final ByteBuffer metadata;
    private final boolean isSorted;
    private final int offsetSize;
    private final int offsetListOffset;
    private final int dataOffset;
    private final String[] dict;

    static SerializedMetadata from(byte[] bytes) {
        return SerializedMetadata.from(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN));
    }

    static SerializedMetadata from(ByteBuffer metadata) {
        Preconditions.checkArgument((metadata.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0, (Object)"Unsupported byte order: big endian");
        int header = VariantUtil.readByte(metadata, 0);
        int version = header & 0xF;
        Preconditions.checkArgument((1 == version ? 1 : 0) != 0, (String)"Unsupported version: %s", (int)version);
        return new SerializedMetadata(metadata, header);
    }

    private SerializedMetadata(ByteBuffer metadata, int header) {
        this.isSorted = (header & 0x10) == 16;
        this.offsetSize = 1 + ((header & 0xC0) >> 6);
        int dictSize = VariantUtil.readLittleEndianUnsigned(metadata, 1, this.offsetSize);
        this.dict = new String[dictSize];
        this.offsetListOffset = 1 + this.offsetSize;
        this.dataOffset = this.offsetListOffset + (1 + dictSize) * this.offsetSize;
        int endOffset = this.dataOffset + VariantUtil.readLittleEndianUnsigned(metadata, this.offsetListOffset + this.offsetSize * dictSize, this.offsetSize);
        this.metadata = endOffset < metadata.limit() ? VariantUtil.slice(metadata, 0, endOffset) : metadata;
    }

    @Override
    public int dictionarySize() {
        return this.dict.length;
    }

    @VisibleForTesting
    boolean isSorted() {
        return this.isSorted;
    }

    @Override
    public int id(String name) {
        if (name != null) {
            if (this.isSorted) {
                return VariantUtil.find(this.dict.length, name, this::get);
            }
            for (int id = 0; id < this.dict.length; ++id) {
                if (!name.equals(this.get(id))) continue;
                return id;
            }
        }
        return -1;
    }

    @Override
    public String get(int index) {
        if (null == this.dict[index]) {
            int offset = VariantUtil.readLittleEndianUnsigned(this.metadata, this.offsetListOffset + this.offsetSize * index, this.offsetSize);
            int next = VariantUtil.readLittleEndianUnsigned(this.metadata, this.offsetListOffset + this.offsetSize * (1 + index), this.offsetSize);
            this.dict[index] = VariantUtil.readString(this.metadata, this.dataOffset + offset, next - offset);
        }
        return this.dict[index];
    }

    @Override
    public ByteBuffer buffer() {
        return this.metadata;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer().remaining();
    }

    @Override
    public int writeTo(ByteBuffer buffer, int offset) {
        ByteBuffer value = this.buffer();
        VariantUtil.writeBufferAbsolute(buffer, offset, value);
        return value.remaining();
    }

    public String toString() {
        return VariantMetadata.asString(this);
    }
}

