/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.Optional;

public class Ref {
    private final Optional<Long> versionNumber;
    private final Optional<String> branchName;
    private final Optional<String> tagName;

    public Ref(Optional<Long> versionNumber, Optional<String> branchName, Optional<String> tagName) {
        this.versionNumber = versionNumber;
        this.branchName = branchName;
        this.tagName = tagName;
    }

    public Optional<Long> getVersionNumber() {
        return this.versionNumber;
    }

    public Optional<String> getBranchName() {
        return this.branchName;
    }

    public Optional<String> getTagName() {
        return this.tagName;
    }

    public static Ref ofMain(long versionNumber) {
        return new Ref(Optional.of(versionNumber), Optional.empty(), Optional.empty());
    }

    public static Ref ofMain() {
        return new Ref(Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static Ref ofBranch(String branchName) {
        return new Ref(Optional.empty(), Optional.of(branchName), Optional.empty());
    }

    public static Ref ofBranch(String branchName, long versionNumber) {
        return new Ref(Optional.of(versionNumber), Optional.of(branchName), Optional.empty());
    }

    public static Ref ofTag(String tagName) {
        return new Ref(Optional.empty(), Optional.empty(), Optional.of(tagName));
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("versionNumber", this.versionNumber.orElse(null)).add("branchName", this.branchName.orElse(null)).add("tagName", this.tagName.orElse(null)).toString();
    }
}

