/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.index.vector;

import com.lancedb.lance.shaded.guava.base.MoreObjects;

public class PQBuildParams {
    private final int numSubVectors;
    private final int numBits;
    private final int maxIters;
    private final int kmeansRedos;
    private final int sampleRate;

    private PQBuildParams(Builder builder) {
        this.numSubVectors = builder.numSubVectors;
        this.numBits = builder.numBits;
        this.maxIters = builder.maxIters;
        this.kmeansRedos = builder.kmeansRedos;
        this.sampleRate = builder.sampleRate;
    }

    public int getNumSubVectors() {
        return this.numSubVectors;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public int getMaxIters() {
        return this.maxIters;
    }

    public int getKmeansRedos() {
        return this.kmeansRedos;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("numSubVectors", this.numSubVectors).add("numBits", this.numBits).add("maxIters", this.maxIters).add("kmeansRedos", this.kmeansRedos).add("sampleRate", this.sampleRate).toString();
    }

    public static class Builder {
        private int numSubVectors = 16;
        private int numBits = 8;
        private int maxIters = 50;
        private int kmeansRedos = 1;
        private int sampleRate = 256;

        public Builder setNumSubVectors(int numSubVectors) {
            this.numSubVectors = numSubVectors;
            return this;
        }

        public Builder setNumBits(int numBits) {
            this.numBits = numBits;
            return this;
        }

        public Builder setMaxIters(int maxIters) {
            this.maxIters = maxIters;
            return this;
        }

        public Builder setKmeansRedos(int kmeansRedos) {
            this.kmeansRedos = kmeansRedos;
            return this;
        }

        public Builder setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public PQBuildParams build() {
            return new PQBuildParams(this);
        }
    }
}

