/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.writable;

import java.io.Serializable;
import org.apache.paimon.data.columnar.Dictionary;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;

public abstract class AbstractWritableVector
implements WritableColumnVector,
Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean noNulls = true;
    protected boolean isAllNull = false;
    protected int elementsAppended;
    protected int capacity;
    protected Dictionary dictionary;

    public AbstractWritableVector(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public void setDictionary(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public boolean hasDictionary() {
        return this.dictionary != null;
    }

    @Override
    public void setAllNull() {
        this.isAllNull = true;
        this.noNulls = false;
    }

    @Override
    public boolean isAllNull() {
        return this.isAllNull;
    }

    @Override
    public int getElementsAppended() {
        return this.elementsAppended;
    }

    @Override
    public final void addElementsAppended(int num) {
        this.elementsAppended += num;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void reset() {
        this.noNulls = true;
        this.isAllNull = false;
        this.elementsAppended = 0;
    }

    @Override
    public void reserve(int requiredCapacity) {
        if (requiredCapacity < 0) {
            throw new IllegalArgumentException("Invalid capacity: " + requiredCapacity);
        }
        if (requiredCapacity > this.capacity) {
            int newCapacity = (int)Math.min(Integer.MAX_VALUE, (long)requiredCapacity * 2L);
            if (requiredCapacity <= newCapacity) {
                try {
                    this.reserveInternal(newCapacity);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new RuntimeException("Failed to allocate memory for vector", outOfMemoryError);
                }
            } else {
                throw new UnsupportedOperationException("Cannot allocate :" + newCapacity + " elements");
            }
            this.capacity = newCapacity;
        }
    }

    protected abstract void reserveInternal(int var1);
}

