/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FatalExitExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FatalExitExceptionHandler.class);
    public static final FatalExitExceptionHandler INSTANCE = new FatalExitExceptionHandler();
    public static final int EXIT_CODE = -17;

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            LOG.error("FATAL: Thread '{}' produced an uncaught exception. Stopping the process...", (Object)t.getName(), (Object)e);
            ThreadUtils.errorLogThreadDump((Logger)LOG);
        }
        finally {
            System.exit(-17);
        }
    }
}

