/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchRoleException;

public class DeleteRole
extends Command {
    public static final Joiner COMMA_JOINER = Joiner.on(", ").skipNulls();
    protected String metalake;
    protected String[] roles;
    protected boolean force;

    public DeleteRole(CommandContext context, String metalake, String[] roles) {
        super(context);
        this.metalake = metalake;
        this.force = context.force();
        this.roles = roles;
    }

    @Override
    public void handle() {
        if (!AreYouSure.really(this.force)) {
            return;
        }
        ArrayList failedRoles = Lists.newArrayList();
        ArrayList<String> successRoles = Lists.newArrayList();
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            for (String role : this.roles) {
                (client.deleteRole(role) ? successRoles : failedRoles).add(role);
            }
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchRoleException err) {
            this.exitWithError("Unknown role.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (failedRoles.isEmpty()) {
            this.printInformation(COMMA_JOINER.join(successRoles) + " deleted.");
        } else {
            this.printInformation(COMMA_JOINER.join(successRoles) + " deleted, but " + COMMA_JOINER.join(failedRoles) + " is not deleted.");
        }
    }
}

