/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.ArrayList;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchRoleException;
import org.apache.gravitino.exceptions.NoSuchUserException;

public class RemoveRoleFromGroup
extends Command {
    protected String metalake;
    protected String group;
    protected String role;

    public RemoveRoleFromGroup(CommandContext context, String metalake, String group, String role) {
        super(context);
        this.metalake = metalake;
        this.group = group;
        this.role = role;
    }

    @Override
    public void handle() {
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            ArrayList<String> roles = new ArrayList<String>();
            roles.add(this.role);
            client.revokeRolesFromGroup(roles, this.group);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchRoleException err) {
            this.exitWithError("Unknown role.");
        }
        catch (NoSuchUserException err) {
            this.exitWithError("Unknown user.");
        }
        catch (NoSuchGroupException err) {
            this.exitWithError("Unknown group.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.role + " removed from " + this.group);
    }
}

