/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.tag;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.dto.AuditDTO;
import org.apache.gravitino.tag.Tag;

public class TagDTO
implements Tag {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="comment")
    private String comment;
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="audit")
    private AuditDTO audit;
    @JsonProperty(value="inherited")
    private Optional<Boolean> inherited = Optional.empty();

    private TagDTO() {
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public AuditDTO auditInfo() {
        return this.audit;
    }

    @Override
    public Optional<Boolean> inherited() {
        return this.inherited;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TagDTO)) {
            return false;
        }
        TagDTO tagDTO = (TagDTO)o;
        return Objects.equal(this.name, tagDTO.name) && Objects.equal(this.comment, tagDTO.comment) && Objects.equal(this.properties, tagDTO.properties) && Objects.equal(this.audit, tagDTO.audit);
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.comment, this.properties, this.audit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final TagDTO tagDTO = new TagDTO();

        private Builder() {
        }

        public Builder withName(String name) {
            this.tagDTO.name = name;
            return this;
        }

        public Builder withComment(String comment) {
            this.tagDTO.comment = comment;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.tagDTO.properties = properties;
            return this;
        }

        public Builder withAudit(AuditDTO audit) {
            this.tagDTO.audit = audit;
            return this;
        }

        public Builder withInherited(Optional<Boolean> inherited) {
            this.tagDTO.inherited = inherited;
            return this;
        }

        public TagDTO build() {
            return this.tagDTO;
        }
    }
}

