/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.credential.CredentialCache;
import org.apache.gravitino.credential.CredentialCacheKey;
import org.apache.gravitino.credential.CredentialContext;
import org.apache.gravitino.credential.CredentialProvider;
import org.apache.gravitino.credential.CredentialUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogCredentialManager
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogCredentialManager.class);
    private final CredentialCache<CredentialCacheKey> credentialCache;
    private final String catalogName;
    private final Map<String, CredentialProvider> credentialProviders;

    public CatalogCredentialManager(String catalogName, Map<String, String> catalogProperties) {
        this.catalogName = catalogName;
        this.credentialProviders = CredentialUtils.loadCredentialProviders(catalogProperties);
        this.credentialCache = new CredentialCache();
        this.credentialCache.initialize(catalogProperties);
    }

    public Credential getCredential(String credentialType, CredentialContext context) {
        CredentialCacheKey credentialCacheKey = new CredentialCacheKey(credentialType, context);
        return this.credentialCache.getCredential(credentialCacheKey, (T cacheKey) -> this.doGetCredential((CredentialCacheKey)cacheKey));
    }

    public Credential getCredential(CredentialContext context) {
        if (this.credentialProviders.size() == 0) {
            throw new IllegalArgumentException("There are no credential provider for the catalog.");
        }
        if (this.credentialProviders.size() > 1) {
            throw new UnsupportedOperationException("There are multiple credential providers for the catalog.");
        }
        return this.getCredential(this.credentialProviders.keySet().iterator().next(), context);
    }

    @Override
    public void close() {
        this.credentialProviders.values().forEach(credentialProvider -> {
            try {
                credentialProvider.close();
            }
            catch (IOException e) {
                LOG.warn("Close credential provider failed, catalog: {}, credential provider: {}", new Object[]{this.catalogName, credentialProvider.credentialType(), e});
            }
        });
        try {
            this.credentialCache.close();
        }
        catch (IOException e) {
            LOG.warn("Close credential cache failed, catalog: {}", (Object)this.catalogName, (Object)e);
        }
    }

    private Credential doGetCredential(CredentialCacheKey credentialCacheKey) {
        String credentialType = credentialCacheKey.getCredentialType();
        CredentialContext context = credentialCacheKey.getCredentialContext();
        LOG.debug("Try get credential, credential type: {}, context: {}.", (Object)credentialType, (Object)context);
        Preconditions.checkState((boolean)this.credentialProviders.containsKey(credentialType), (Object)String.format("Credential %s not found", credentialType));
        return this.credentialProviders.get(credentialType).getCredential(context);
    }
}

