/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MapUtils {
    private MapUtils() {
    }

    public static Map<String, String> getPrefixMap(Map<String, String> m, String prefix) {
        return MapUtils.getPrefixMap(m, prefix, false);
    }

    public static Map<String, String> getPrefixMap(Map<String, String> m, String prefix, boolean keepPrefix) {
        if (m == null || prefix == null) {
            throw new IllegalArgumentException("Map and prefix cannot be null");
        }
        return m.entrySet().stream().filter(entry -> entry.getKey() != null && ((String)entry.getKey()).startsWith(prefix)).collect(Collectors.collectingAndThen(Collectors.toMap(entry -> keepPrefix ? (String)entry.getKey() : ((String)entry.getKey()).substring(prefix.length()), Map.Entry::getValue), Collections::unmodifiableMap));
    }

    public static Map<String, String> getMapWithoutPrefix(Map<String, String> m, String prefix) {
        if (m == null || prefix == null) {
            throw new IllegalArgumentException("Map and prefix cannot be null");
        }
        return m.entrySet().stream().filter(entry -> entry.getKey() == null || !((String)entry.getKey()).startsWith(prefix)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<String, String> getFilteredMap(Map<String, String> m, Predicate predicate) {
        HashMap configs = Maps.newHashMap();
        m.forEach((k, v) -> {
            if (predicate.test(k)) {
                configs.put(k, v);
            }
        });
        return Collections.unmodifiableMap(configs);
    }

    public static Map<String, String> unmodifiableMap(Map<String, String> m) {
        return Collections.unmodifiableMap(m);
    }

    public static int propertyAsInt(Map<String, String> properties, String property, int defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("%s in %s is invalid. %s", value, property, "The value must be an integer number"));
            }
        }
        return defaultValue;
    }

    public static long propertyAsLong(Map<String, String> properties, String property, long defaultValue) {
        String value = properties.get(property);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("%s in %s is invalid. %s", value, property, "The value must be a long number"));
            }
        }
        return defaultValue;
    }
}

