/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public abstract class FileUtil {
    private static final int BUFFER_SIZE = 16384;
    private static final Object region = new Object();
    private static boolean initialized = false;
    private static Method setWrite = null;
    private static Method setRead = null;
    private static Method setExec = null;
    private static Class fileClz = File.class;
    private static Class filesClz;
    private static Class pathClz;
    private static Class pathsClz;
    private static Class aclEntryClz;
    private static Class aclFileAttributeViewClz;
    private static Class posixFileAttributeViewClz;
    private static Class userPrincipalClz;
    private static Class linkOptionArrayClz;
    private static Class linkOptionClz;
    private static Class stringArrayClz;
    private static Class aclEntryBuilderClz;
    private static Class aclEntryTypeClz;
    private static Class fileStoreClz;
    private static Class aclEntryPermissionClz;
    private static Method get;
    private static Method getFileAttributeView;
    private static Method supportsFileAttributeView;
    private static Method getFileStore;
    private static Method getOwner;
    private static Method getAcl;
    private static Method setAcl;
    private static Method principal;
    private static Method getName;
    private static Method build;
    private static Method newBuilder;
    private static Method setPrincipal;
    private static Method setType;
    private static Method values;
    private static Method setPermissions;
    private static Field allow;

    public static boolean removeDirectory(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (!(file2.isDirectory() ? !FileUtil.removeDirectory(file2) : !file2.delete())) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean removeDirectory(String string) {
        return FileUtil.removeDirectory(new File(string));
    }

    public static boolean copyDirectory(File file, File file2) {
        return FileUtil.copyDirectory(file, file2, null, null);
    }

    public static boolean copyDirectory(String string, String string2) {
        return FileUtil.copyDirectory(new File(string), new File(string2));
    }

    public static boolean copyDirectory(File file, File file2, byte[] byArray, String[] stringArray) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        if (file2.exists()) {
            return false;
        }
        if (!file2.mkdirs()) {
            return false;
        }
        FileUtil.limitAccessToOwner(file2);
        String[] stringArray2 = file.list();
        if (stringArray2 != null) {
            if (byArray == null) {
                byArray = new byte[16384];
            }
            block0: for (int i = 0; i < stringArray2.length; ++i) {
                File file3;
                String string = stringArray2[i];
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (string.equals(stringArray[j])) continue block0;
                    }
                }
                if (!((file3 = new File(file, string)).isDirectory() ? !FileUtil.copyDirectory(file3, new File(file2, string), byArray, stringArray) : !FileUtil.copyFile(file3, new File(file2, string), byArray))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File file, File file2, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[16384];
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            FileUtil.limitAccessToOwner(file2);
            int n = fileInputStream.read(byArray);
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
            fileInputStream.close();
            fileInputStream = null;
            fileOutputStream.getFD().sync();
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean copyDirectory(StorageFactory storageFactory, StorageFile storageFile, File file, byte[] byArray, String[] stringArray, boolean bl) {
        if (storageFile == null) {
            return false;
        }
        if (!storageFile.exists()) {
            return true;
        }
        if (!storageFile.isDirectory()) {
            return false;
        }
        if (file.exists()) {
            return false;
        }
        if (!file.mkdirs()) {
            return false;
        }
        FileUtil.limitAccessToOwner(file);
        String[] stringArray2 = storageFile.list();
        if (stringArray2 != null) {
            if (byArray == null) {
                byArray = new byte[16384];
            }
            block0: for (int i = 0; i < stringArray2.length; ++i) {
                StorageFile storageFile2;
                String string = stringArray2[i];
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (string.equals(stringArray[j])) continue block0;
                    }
                }
                if (!((storageFile2 = storageFactory.newStorageFile(storageFile, string)).isDirectory() ? bl && !FileUtil.copyDirectory(storageFactory, storageFile2, new File(file, string), byArray, stringArray, bl) : !FileUtil.copyFile(storageFactory, storageFile2, new File(file, string), byArray))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(StorageFactory storageFactory, StorageFile storageFile, File file) {
        return FileUtil.copyFile(storageFactory, storageFile, file, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(StorageFactory storageFactory, StorageFile storageFile, File file, byte[] byArray) {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = storageFile.getInputStream();
            fileOutputStream = new FileOutputStream(file);
            FileUtil.limitAccessToOwner(file);
            if (byArray == null) {
                byArray = new byte[16384];
            }
            int n = inputStream.read(byArray);
            while (n != -1) {
                fileOutputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            inputStream.close();
            inputStream = null;
            fileOutputStream.getFD().sync();
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean copyDirectory(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile) {
        return FileUtil.copyDirectory(writableStorageFactory, file, storageFile, null, null);
    }

    public static boolean copyDirectory(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile, byte[] byArray, String[] stringArray) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        if (storageFile.exists()) {
            return false;
        }
        if (!storageFile.mkdirs()) {
            return false;
        }
        storageFile.limitAccessToOwner();
        String[] stringArray2 = file.list();
        if (stringArray2 != null) {
            if (byArray == null) {
                byArray = new byte[16384];
            }
            block0: for (int i = 0; i < stringArray2.length; ++i) {
                File file2;
                String string = stringArray2[i];
                if (stringArray != null) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (string.equals(stringArray[j])) continue block0;
                    }
                }
                if (!((file2 = new File(file, string)).isDirectory() ? !FileUtil.copyDirectory(writableStorageFactory, file2, writableStorageFactory.newStorageFile(storageFile, string), byArray, stringArray) : !FileUtil.copyFile(writableStorageFactory, file2, writableStorageFactory.newStorageFile(storageFile, string), byArray))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean copyFile(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile) {
        return FileUtil.copyFile(writableStorageFactory, file, storageFile, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(WritableStorageFactory writableStorageFactory, File file, StorageFile storageFile, byte[] byArray) {
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            outputStream = storageFile.getOutputStream();
            if (byArray == null) {
                byArray = new byte[16384];
            }
            int n = ((InputStream)fileInputStream).read(byArray);
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                n = ((InputStream)fileInputStream).read(byArray);
            }
            ((InputStream)fileInputStream).close();
            fileInputStream = null;
            writableStorageFactory.sync(outputStream, false);
            outputStream.close();
            outputStream = null;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static boolean copyFile(WritableStorageFactory writableStorageFactory, StorageFile storageFile, StorageFile storageFile2) {
        return FileUtil.copyFile(writableStorageFactory, storageFile, storageFile2, (byte[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(WritableStorageFactory writableStorageFactory, StorageFile storageFile, StorageFile storageFile2, byte[] byArray) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = storageFile.getInputStream();
            outputStream = storageFile2.getOutputStream();
            if (byArray == null) {
                byArray = new byte[16384];
            }
            int n = inputStream.read(byArray);
            while (n != -1) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
            inputStream.close();
            inputStream = null;
            writableStorageFactory.sync(outputStream, false);
            outputStream.close();
            outputStream = null;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public static File getAbsoluteFile(File file, String string) {
        File file2 = new File(string);
        if (file2.isAbsolute()) {
            return file2;
        }
        if (file == null) {
            return null;
        }
        return new File(file, string);
    }

    public static File newFile(File file, String string) {
        if (file == null) {
            return new File(string);
        }
        return new File(file, string);
    }

    public static String stripProtocolFromFileName(String string) {
        String string2 = string;
        try {
            URL uRL = new URL(string);
            string2 = uRL.getFile();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void limitAccessToOwner(File file) {
        String string = PropertyUtil.getSystemProperty("derby.storage.useDefaultFilePermissions");
        if (string != null) {
            if (Boolean.valueOf(string.trim()).booleanValue()) {
                return;
            }
        } else if (JVMInfo.JDK_ID < 8 || !PropertyUtil.getSystemBoolean("derby.__serverStartedFromCmdLine", false)) {
            return;
        }
        Object object = region;
        synchronized (object) {
            if (!initialized) {
                initialized = true;
                try {
                    setWrite = fileClz.getMethod("setWritable", Boolean.TYPE, Boolean.TYPE);
                    setRead = fileClz.getMethod("setReadable", Boolean.TYPE, Boolean.TYPE);
                    setExec = fileClz.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                try {
                    filesClz = Class.forName("java.nio.file.Files");
                    pathClz = Class.forName("java.nio.file.Path");
                    pathsClz = Class.forName("java.nio.file.Paths");
                    aclEntryClz = Class.forName("java.nio.file.attribute.AclEntry");
                    aclFileAttributeViewClz = Class.forName("java.nio.file.attribute.AclFileAttributeView");
                    posixFileAttributeViewClz = Class.forName("java.nio.file.attribute.PosixFileAttributeView");
                    userPrincipalClz = Class.forName("java.nio.file.attribute.UserPrincipal");
                    linkOptionArrayClz = Class.forName("[Ljava.nio.file.LinkOption;");
                    linkOptionClz = Class.forName("java.nio.file.LinkOption");
                    stringArrayClz = Class.forName("[Ljava.lang.String;");
                    aclEntryBuilderClz = Class.forName("java.nio.file.attribute.AclEntry$Builder");
                    aclEntryTypeClz = Class.forName("java.nio.file.attribute.AclEntryType");
                    fileStoreClz = Class.forName("java.nio.file.FileStore");
                    aclEntryPermissionClz = Class.forName("java.nio.file.attribute.AclEntryPermission");
                    get = pathsClz.getMethod("get", String.class, stringArrayClz);
                    getFileAttributeView = filesClz.getMethod("getFileAttributeView", pathClz, Class.class, linkOptionArrayClz);
                    supportsFileAttributeView = fileStoreClz.getMethod("supportsFileAttributeView", Class.class);
                    getFileStore = filesClz.getMethod("getFileStore", pathClz);
                    getOwner = filesClz.getMethod("getOwner", pathClz, linkOptionArrayClz);
                    getAcl = aclFileAttributeViewClz.getMethod("getAcl", new Class[0]);
                    setAcl = aclFileAttributeViewClz.getMethod("setAcl", List.class);
                    principal = aclEntryClz.getMethod("principal", new Class[0]);
                    getName = userPrincipalClz.getMethod("getName", new Class[0]);
                    build = aclEntryBuilderClz.getMethod("build", new Class[0]);
                    newBuilder = aclEntryClz.getMethod("newBuilder", new Class[0]);
                    setPrincipal = aclEntryBuilderClz.getMethod("setPrincipal", userPrincipalClz);
                    setType = aclEntryBuilderClz.getMethod("setType", aclEntryTypeClz);
                    values = aclEntryPermissionClz.getMethod("values", null);
                    setPermissions = aclEntryBuilderClz.getMethod("setPermissions", Set.class);
                    allow = aclEntryTypeClz.getField("ALLOW");
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
        if (setWrite == null) {
            return;
        }
        if (FileUtil.limitAccessToOwnerViaACLs(file)) {
            return;
        }
        try {
            object = setWrite.invoke((Object)file, Boolean.FALSE, Boolean.FALSE);
            FileUtil.assertTrue(object);
            object = setWrite.invoke((Object)file, Boolean.TRUE, Boolean.TRUE);
            FileUtil.assertTrue(object);
            object = setRead.invoke((Object)file, Boolean.FALSE, Boolean.FALSE);
            FileUtil.assertTrue(object);
            object = setRead.invoke((Object)file, Boolean.TRUE, Boolean.TRUE);
            FileUtil.assertTrue(object);
            if (file.isDirectory()) {
                object = setExec.invoke((Object)file, Boolean.FALSE, Boolean.FALSE);
                FileUtil.assertTrue(object);
                object = setExec.invoke((Object)file, Boolean.TRUE, Boolean.TRUE);
                FileUtil.assertTrue(object);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (SecurityException)invocationTargetException.getCause();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void assertTrue(Object object) {
    }

    private static boolean limitAccessToOwnerViaACLs(File file) {
        if (filesClz == null) {
            return false;
        }
        try {
            Object object = get.invoke(null, file.getPath(), new String[0]);
            Object object2 = getFileStore.invoke(null, object);
            boolean bl = (Boolean)supportsFileAttributeView.invoke(object2, aclFileAttributeViewClz);
            if (!bl) {
                return false;
            }
            Object object3 = getFileAttributeView.invoke(null, object, aclFileAttributeViewClz, Array.newInstance(linkOptionClz, 0));
            if (object3 == null) {
                return false;
            }
            Object object4 = getFileAttributeView.invoke(null, object, posixFileAttributeViewClz, Array.newInstance(linkOptionClz, 0));
            if (object4 != null) {
                return false;
            }
            Object object5 = getOwner.invoke(null, object, Array.newInstance(linkOptionClz, 0));
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object[] objectArray = (Object[])values.invoke(null, (Object[])null);
            Object object6 = newBuilder.invoke(null, (Object[])null);
            Object object7 = allow.get(aclEntryTypeClz);
            object6 = setPrincipal.invoke(object6, object5);
            object6 = setType.invoke(object6, object7);
            object6 = setPermissions.invoke(object6, new HashSet<Object>(Arrays.asList(objectArray)));
            arrayList.add(build.invoke(object6, (Object[])null));
            setAcl.invoke(object3, arrayList);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (RuntimeException)invocationTargetException.getCause();
        }
        return true;
    }
}

