/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.iceberg.converter;

import java.util.List;
import java.util.Map;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.FunctionExpression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.literals.Literals;
import org.apache.gravitino.rel.expressions.sorts.NullOrdering;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.expressions.sorts.SortOrders;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.transforms.SortOrderVisitor;

public class FromIcebergSortOrder
implements SortOrderVisitor<org.apache.gravitino.rel.expressions.sorts.SortOrder> {
    private final Map<Integer, String> idToName;

    public FromIcebergSortOrder(Schema schema) {
        this.idToName = schema.idToName();
    }

    public org.apache.gravitino.rel.expressions.sorts.SortOrder field(String sourceName, int id, org.apache.iceberg.SortDirection direction, NullOrder nullOrder) {
        return this.fieldSortOrder(id, direction, nullOrder);
    }

    public org.apache.gravitino.rel.expressions.sorts.SortOrder bucket(String sourceName, int id, int width, org.apache.iceberg.SortDirection direction, NullOrder nullOrder) {
        return this.functionSortOrder("bucket", width, id, direction, nullOrder);
    }

    public org.apache.gravitino.rel.expressions.sorts.SortOrder truncate(String sourceName, int id, int width, org.apache.iceberg.SortDirection direction, NullOrder nullOrder) {
        return this.functionSortOrder("truncate", width, id, direction, nullOrder);
    }

    public org.apache.gravitino.rel.expressions.sorts.SortOrder year(String sourceName, int id, org.apache.iceberg.SortDirection direction, NullOrder nullOrder) {
        return this.functionSortOrder("year", id, direction, nullOrder);
    }

    public org.apache.gravitino.rel.expressions.sorts.SortOrder month(String sourceName, int id, org.apache.iceberg.SortDirection direction, NullOrder nullOrder) {
        return this.functionSortOrder("month", id, direction, nullOrder);
    }

    public org.apache.gravitino.rel.expressions.sorts.SortOrder day(String sourceName, int id, org.apache.iceberg.SortDirection direction, NullOrder nullOrder) {
        return this.functionSortOrder("day", id, direction, nullOrder);
    }

    public org.apache.gravitino.rel.expressions.sorts.SortOrder hour(String sourceName, int id, org.apache.iceberg.SortDirection direction, NullOrder nullOrder) {
        return this.functionSortOrder("hour", id, direction, nullOrder);
    }

    private org.apache.gravitino.rel.expressions.sorts.SortOrder fieldSortOrder(int id, org.apache.iceberg.SortDirection direction, NullOrder nullOrder) {
        return SortOrders.of((Expression)NamedReference.field((String)this.idToName.get(id)), (SortDirection)this.toGravitino(direction), (NullOrdering)this.toGravitino(nullOrder));
    }

    private org.apache.gravitino.rel.expressions.sorts.SortOrder functionSortOrder(String name, int id, org.apache.iceberg.SortDirection direction, NullOrder nullOrder) {
        return SortOrders.of((Expression)FunctionExpression.of((String)name, (Expression[])new Expression[]{NamedReference.field((String)this.idToName.get(id))}), (SortDirection)this.toGravitino(direction), (NullOrdering)this.toGravitino(nullOrder));
    }

    private org.apache.gravitino.rel.expressions.sorts.SortOrder functionSortOrder(String name, int width, int id, org.apache.iceberg.SortDirection direction, NullOrder nullOrder) {
        return SortOrders.of((Expression)FunctionExpression.of((String)name, (Expression[])new Expression[]{Literals.integerLiteral((Integer)width), NamedReference.field((String)this.idToName.get(id))}), (SortDirection)this.toGravitino(direction), (NullOrdering)this.toGravitino(nullOrder));
    }

    private SortDirection toGravitino(org.apache.iceberg.SortDirection direction) {
        return direction == org.apache.iceberg.SortDirection.ASC ? SortDirection.ASCENDING : SortDirection.DESCENDING;
    }

    private NullOrdering toGravitino(NullOrder nullOrder) {
        return nullOrder == NullOrder.NULLS_FIRST ? NullOrdering.NULLS_FIRST : NullOrdering.NULLS_LAST;
    }

    public static org.apache.gravitino.rel.expressions.sorts.SortOrder[] fromSortOrder(SortOrder sortOrder) {
        FromIcebergSortOrder visitor = new FromIcebergSortOrder(sortOrder.schema());
        List ordering = SortOrderVisitor.visit((SortOrder)sortOrder, (SortOrderVisitor)visitor);
        return ordering.toArray(new org.apache.gravitino.rel.expressions.sorts.SortOrder[0]);
    }
}

