/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionParser;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.requests.PlanTableScanRequest;
import org.apache.iceberg.util.JsonUtil;

public class PlanTableScanRequestParser {
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String SELECT = "select";
    private static final String FILTER = "filter";
    private static final String CASE_SENSITIVE = "case-sensitive";
    private static final String USE_SNAPSHOT_SCHEMA = "use-snapshot-schema";
    private static final String START_SNAPSHOT_ID = "start-snapshot-id";
    private static final String END_SNAPSHOT_ID = "end-snapshot-id";
    private static final String STATS_FIELDS = "stats-fields";

    private PlanTableScanRequestParser() {
    }

    public static String toJson(PlanTableScanRequest request) {
        return PlanTableScanRequestParser.toJson(request, false);
    }

    public static String toJson(PlanTableScanRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> PlanTableScanRequestParser.toJson(request, gen), pretty);
    }

    public static void toJson(PlanTableScanRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != request ? 1 : 0) != 0, (Object)"Invalid planTableScanRequest: null");
        if (request.snapshotId() != null || request.startSnapshotId() != null || request.endSnapshotId() != null) {
            Preconditions.checkArgument((boolean)(request.snapshotId() != null ^ (request.startSnapshotId() != null && request.endSnapshotId() != null)), (Object)"Either snapshotId must be provided or both startSnapshotId and endSnapshotId must be provided");
        }
        gen.writeStartObject();
        if (request.snapshotId() != null) {
            gen.writeNumberField(SNAPSHOT_ID, request.snapshotId().longValue());
        }
        if (request.startSnapshotId() != null) {
            gen.writeNumberField(START_SNAPSHOT_ID, request.startSnapshotId().longValue());
        }
        if (request.endSnapshotId() != null) {
            gen.writeNumberField(END_SNAPSHOT_ID, request.endSnapshotId().longValue());
        }
        if (request.select() != null && !request.select().isEmpty()) {
            JsonUtil.writeStringArray(SELECT, request.select(), gen);
        }
        if (request.filter() != null) {
            gen.writeStringField(FILTER, ExpressionParser.toJson(request.filter()));
        }
        gen.writeBooleanField(CASE_SENSITIVE, request.caseSensitive());
        gen.writeBooleanField(USE_SNAPSHOT_SCHEMA, request.useSnapshotSchema());
        if (request.statsFields() != null && !request.statsFields().isEmpty()) {
            JsonUtil.writeStringArray(STATS_FIELDS, request.statsFields(), gen);
        }
        gen.writeEndObject();
    }

    public static PlanTableScanRequest fromJson(String json) {
        return JsonUtil.parse(json, PlanTableScanRequestParser::fromJson);
    }

    public static PlanTableScanRequest fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Invalid planTableScanRequest: null");
        Long snapshotId = JsonUtil.getLongOrNull(SNAPSHOT_ID, json);
        Long startSnapshotId = JsonUtil.getLongOrNull(START_SNAPSHOT_ID, json);
        Long endSnapshotId = JsonUtil.getLongOrNull(END_SNAPSHOT_ID, json);
        List<String> select = JsonUtil.getStringListOrNull(SELECT, json);
        Expression filter = null;
        if (json.has(FILTER)) {
            filter = ExpressionParser.fromJson(json.get(FILTER).textValue());
        }
        boolean caseSensitive = true;
        if (json.has(CASE_SENSITIVE)) {
            caseSensitive = JsonUtil.getBool(CASE_SENSITIVE, json);
        }
        boolean useSnapshotSchema = false;
        if (json.has(USE_SNAPSHOT_SCHEMA)) {
            useSnapshotSchema = JsonUtil.getBool(USE_SNAPSHOT_SCHEMA, json);
        }
        List<String> statsFields = JsonUtil.getStringListOrNull(STATS_FIELDS, json);
        return new PlanTableScanRequest.Builder().withSnapshotId(snapshotId).withSelect(select).withFilter(filter).withCaseSensitive(caseSensitive).withUseSnapshotSchema(useSnapshotSchema).withStartSnapshotId(startSnapshotId).withEndSnapshotId(endSnapshotId).withStatsFields(statsFields).build();
    }
}

