/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortCharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.iterator.MutableCharIterator;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.ImmutableCharShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortCharMap;
import org.eclipse.collections.api.map.primitive.ShortCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortCharPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedShortCharProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.CharBags;
import org.eclipse.collections.impl.factory.primitive.CharShortMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.map.mutable.primitive.ShortCharHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;

final class ImmutableShortCharHashMap
implements ImmutableShortCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableShortCharMap delegate;

    ImmutableShortCharHashMap(ShortCharMap delegate) {
        this.delegate = new ShortCharHashMap(delegate);
    }

    public char get(short key) {
        return this.delegate.get(key);
    }

    public char getIfAbsent(short key, char ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public char getOrThrow(short key) {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(short key) {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(char value) {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(CharProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(ShortProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ShortCharProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyShortIterable keysView() {
        return this.delegate.keysView();
    }

    public RichIterable<ShortCharPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    public ImmutableCharShortMap flipUniqueValues() {
        MutableCharShortMap result = CharShortMaps.mutable.empty();
        this.forEachKeyValue((ShortCharProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result.toImmutable();
    }

    public ImmutableShortCharMap select(ShortCharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableShortCharMap reject(ShortCharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return (T)this.delegate.injectInto(injectedValue, function);
    }

    public RichIterable<CharIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            MutableCharIterator iterator = this.delegate.charIterator();
            while (iterator.hasNext()) {
                MutableCharBag batch = CharBags.mutable.empty();
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    batch.add(iterator.next());
                }
                result.add((Object)batch.toImmutable());
            }
        }
        return result.toImmutable();
    }

    public ImmutableShortCharMap toImmutable() {
        return this;
    }

    public CharIterator charIterator() {
        return new UnmodifiableCharIterator((CharIterator)this.delegate.charIterator());
    }

    public void each(CharProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    public int count(CharPredicate predicate) {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableCharBag select(CharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableCharBag reject(CharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        MutableBag bag = this.delegate.collect(function);
        return bag.toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public char max() {
        return this.delegate.max();
    }

    public char maxIfEmpty(char defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public char min() {
        return this.delegate.min();
    }

    public char minIfEmpty(char defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public char[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public MutableCharList toSortedList() {
        return this.delegate.toSortedList();
    }

    public char[] toArray() {
        return this.delegate.toArray();
    }

    public char[] toArray(char[] target) {
        return this.delegate.toArray(target);
    }

    public boolean contains(char value) {
        return this.delegate.contains(value);
    }

    public boolean containsAll(char ... source) {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(CharIterable source) {
        return this.delegate.containsAll(source);
    }

    public MutableCharList toList() {
        return this.delegate.toList();
    }

    public MutableCharSet toSet() {
        return this.delegate.toSet();
    }

    public MutableCharBag toBag() {
        return this.delegate.toBag();
    }

    public LazyCharIterable asLazy() {
        return this.delegate.asLazy();
    }

    public ImmutableShortCharMap newWithKeyValue(short key, char value) {
        ShortCharHashMap map = new ShortCharHashMap(this.size() + 1);
        map.putAll((ShortCharMap)this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableShortCharMap newWithoutKey(short key) {
        ShortCharHashMap map = new ShortCharHashMap(this.size());
        map.putAll((ShortCharMap)this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableShortCharMap newWithoutAllKeys(ShortIterable keys) {
        ShortCharHashMap map = new ShortCharHashMap(this.size());
        map.putAll((ShortCharMap)this);
        ShortIterator iterator = keys.shortIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public String makeString() {
        return this.delegate.makeString();
    }

    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableShortSet keySet() {
        return UnmodifiableShortSet.of(this.delegate.keySet());
    }

    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of(this.delegate.values());
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableShortCharMapSerializationProxy((ShortCharMap)this);
    }

    protected static class ImmutableShortCharMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ShortCharMap map;

        public ImmutableShortCharMapSerializationProxy() {
        }

        protected ImmutableShortCharMapSerializationProxy(ShortCharMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((ShortCharProcedure)new CheckedShortCharProcedure(){

                    @Override
                    public void safeValue(short key, char value) throws IOException {
                        out.writeShort(key);
                        out.writeChar(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ShortCharHashMap deserializedMap = new ShortCharHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readShort(), in.readChar());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

