/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel.partitions;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.dto.rel.expressions.LiteralDTO;
import org.apache.gravitino.dto.rel.partitions.PartitionDTO;
import org.apache.gravitino.rel.partitions.IdentityPartition;

public class IdentityPartitionDTO
implements PartitionDTO,
IdentityPartition {
    private final String name;
    private final String[][] fieldNames;
    private final LiteralDTO[] values;
    private final Map<String, String> properties;

    public static Builder builder() {
        return new Builder();
    }

    private IdentityPartitionDTO() {
        this(null, null, null, null);
    }

    private IdentityPartitionDTO(String name, String[][] fieldNames, LiteralDTO[] values, Map<String, String> properties) {
        this.name = name;
        this.fieldNames = fieldNames;
        this.values = values;
        this.properties = properties;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String[][] fieldNames() {
        return this.fieldNames;
    }

    public LiteralDTO[] values() {
        return this.values;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public PartitionDTO.Type type() {
        return PartitionDTO.Type.IDENTITY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityPartitionDTO)) {
            return false;
        }
        IdentityPartitionDTO that = (IdentityPartitionDTO)o;
        return Objects.equals(this.name, that.name) && Arrays.deepEquals((Object[])this.fieldNames, (Object[])that.fieldNames) && Arrays.equals(this.values, that.values) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.name, Arrays.deepHashCode((Object[])this.fieldNames), Arrays.hashCode(this.values), this.properties);
    }

    public static class Builder {
        private String name;
        private String[][] fieldNames;
        private LiteralDTO[] values;
        private Map<String, String> properties;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withFieldNames(String[][] fieldNames) {
            this.fieldNames = fieldNames;
            return this;
        }

        public Builder withValues(LiteralDTO[] values) {
            this.values = values;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public IdentityPartitionDTO build() {
            return new IdentityPartitionDTO(this.name, this.fieldNames, this.values, this.properties);
        }
    }
}

