/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Set;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ManagedParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueuePath;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class CSQueueUtils {
    public static final float EPSILON = 0.001f;

    public static void checkMaxCapacity(QueuePath queuePath, float capacity, float maximumCapacity) {
        if (maximumCapacity < 0.0f || maximumCapacity > 1.0f) {
            throw new IllegalArgumentException("Illegal value  of maximumCapacity " + maximumCapacity + " used in call to setMaxCapacity for queue " + queuePath);
        }
    }

    public static void checkAbsoluteCapacity(QueuePath queuePath, float absCapacity, float absMaxCapacity) {
        if (absMaxCapacity < absCapacity - 0.001f) {
            throw new IllegalArgumentException("Illegal call to setMaxCapacity. Queue '" + queuePath + "' has an absolute capacity (" + absCapacity + ") greater than its absolute maximumCapacity (" + absMaxCapacity + ")");
        }
    }

    public static float computeAbsoluteMaximumCapacity(float maximumCapacity, CSQueue parent) {
        float parentAbsMaxCapacity = parent == null ? 1.0f : parent.getAbsoluteMaximumCapacity();
        return parentAbsMaxCapacity * maximumCapacity;
    }

    public static void loadCapacitiesByLabelsFromConf(QueuePath queuePath, QueueCapacities queueCapacities, CapacitySchedulerConfiguration csConf, Set<String> nodeLabels) {
        queueCapacities.clearConfigurableFields();
        for (String label : nodeLabels) {
            if (label.equals("")) {
                queueCapacities.setCapacity(label, csConf.getNonLabeledQueueCapacity(queuePath) / 100.0f);
                queueCapacities.setMaximumCapacity(label, csConf.getNonLabeledQueueMaximumCapacity(queuePath) / 100.0f);
                queueCapacities.setMaxAMResourcePercentage(label, csConf.getMaximumAMResourcePercentPerPartition(queuePath, label));
                queueCapacities.setWeight(label, csConf.getNonLabeledQueueWeight(queuePath.getFullPath()));
                continue;
            }
            queueCapacities.setCapacity(label, csConf.getLabeledQueueCapacity(queuePath, label) / 100.0f);
            queueCapacities.setMaximumCapacity(label, csConf.getLabeledQueueMaximumCapacity(queuePath, label) / 100.0f);
            queueCapacities.setMaxAMResourcePercentage(label, csConf.getMaximumAMResourcePercentPerPartition(queuePath, label));
            queueCapacities.setWeight(label, csConf.getLabeledQueueWeight(queuePath, label));
        }
    }

    public static void updateUsedCapacity(ResourceCalculator rc, Resource totalPartitionResource, String nodePartition, AbstractCSQueue childQueue) {
        QueueCapacities queueCapacities = childQueue.getQueueCapacities();
        CSQueueMetrics queueMetrics = childQueue.getMetrics();
        ResourceUsage queueResourceUsage = childQueue.getQueueResourceUsage();
        Resource minimumAllocation = childQueue.getMinimumAllocation();
        float absoluteUsedCapacity = 0.0f;
        float usedCapacity = 0.0f;
        float reservedCapacity = 0.0f;
        float absoluteReservedCapacity = 0.0f;
        if (Resources.greaterThan((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)totalPartitionResource, (Resource)Resources.none())) {
            Resource queueGuaranteedResource = childQueue.getEffectiveCapacity(nodePartition);
            if (Float.compare(queueCapacities.getAbsoluteCapacity(nodePartition), 0.0f) == 0 && childQueue instanceof AutoCreatedLeafQueue) {
                ManagedParentQueue parentQueue = (ManagedParentQueue)childQueue.getParent();
                QueueCapacities leafQueueTemplateCapacities = parentQueue.getLeafQueueTemplate().getQueueCapacities();
                queueGuaranteedResource = Resources.multiply((Resource)totalPartitionResource, (double)leafQueueTemplateCapacities.getAbsoluteCapacity(nodePartition));
            }
            queueGuaranteedResource = Resources.max((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)queueGuaranteedResource, (Resource)minimumAllocation);
            Resource usedResource = queueResourceUsage.getUsed(nodePartition);
            absoluteUsedCapacity = Resources.divide((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)usedResource, (Resource)totalPartitionResource);
            usedCapacity = Resources.divide((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)usedResource, (Resource)queueGuaranteedResource);
            Resource resResource = queueResourceUsage.getReserved(nodePartition);
            reservedCapacity = Resources.divide((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)resResource, (Resource)queueGuaranteedResource);
            absoluteReservedCapacity = Resources.divide((ResourceCalculator)rc, (Resource)totalPartitionResource, (Resource)resResource, (Resource)totalPartitionResource);
        }
        queueCapacities.setAbsoluteUsedCapacity(nodePartition, absoluteUsedCapacity);
        queueCapacities.setUsedCapacity(nodePartition, usedCapacity);
        queueCapacities.setReservedCapacity(nodePartition, reservedCapacity);
        queueCapacities.setAbsoluteReservedCapacity(nodePartition, absoluteReservedCapacity);
        queueMetrics.setUsedCapacity(nodePartition, queueCapacities.getUsedCapacity(""));
        queueMetrics.setAbsoluteUsedCapacity(nodePartition, Float.valueOf(queueCapacities.getAbsoluteUsedCapacity("")));
    }

    private static Resource getMaxAvailableResourceToQueuePartition(ResourceCalculator rc, CSQueue queue, Resource cluster, String partition) {
        Resource queueGuaranteedResource = queue.getEffectiveCapacity(partition);
        Resource available = Resources.greaterThan((ResourceCalculator)rc, (Resource)cluster, (Resource)queueGuaranteedResource, (Resource)queue.getQueueResourceUsage().getUsed(partition)) ? Resources.componentwiseMax((Resource)Resources.subtractFrom((Resource)queueGuaranteedResource, (Resource)queue.getQueueResourceUsage().getUsed(partition)), (Resource)Resources.none()) : Resources.none();
        return available;
    }

    @Lock(value={CSQueue.class})
    public static void updateQueueStatistics(ResourceCalculator rc, Resource cluster, AbstractCSQueue childQueue, RMNodeLabelsManager nlm, String nodePartition) {
        QueueCapacities queueCapacities = childQueue.getQueueCapacities();
        ResourceUsage queueResourceUsage = childQueue.getQueueResourceUsage();
        if (nodePartition == null) {
            for (String partition : Sets.union(queueCapacities.getExistingNodeLabels(), queueResourceUsage.getExistingNodeLabels())) {
                CSQueueUtils.updateUsedCapacity(rc, nlm.getResourceByLabel(partition, cluster), partition, childQueue);
                childQueue.getMetrics().setAvailableResourcesToQueue(partition, CSQueueUtils.getMaxAvailableResourceToQueuePartition(rc, childQueue, cluster, partition));
            }
        } else {
            CSQueueUtils.updateUsedCapacity(rc, nlm.getResourceByLabel(nodePartition, cluster), nodePartition, childQueue);
            childQueue.getMetrics().setAvailableResourcesToQueue(nodePartition, CSQueueUtils.getMaxAvailableResourceToQueuePartition(rc, childQueue, cluster, nodePartition));
        }
    }

    public static void updateConfiguredCapacityMetrics(ResourceCalculator rc, Resource partitionResource, String partition, AbstractCSQueue queue) {
        queue.getMetrics().setGuaranteedResources(partition, rc.multiplyAndNormalizeDown(partitionResource, (double)queue.getQueueCapacities().getAbsoluteCapacity(partition), queue.getMinimumAllocation()));
        queue.getMetrics().setMaxCapacityResources(partition, rc.multiplyAndNormalizeDown(partitionResource, (double)queue.getQueueCapacities().getAbsoluteMaximumCapacity(partition), queue.getMinimumAllocation()));
        queue.getMetrics().setGuaranteedCapacities(partition, queue.getQueueCapacities().getCapacity(partition), queue.getQueueCapacities().getAbsoluteCapacity(partition));
        queue.getMetrics().setMaxCapacities(partition, queue.getQueueCapacities().getMaximumCapacity(partition), queue.getQueueCapacities().getAbsoluteMaximumCapacity(partition));
    }

    public static void updateAbsoluteCapacitiesByNodeLabels(QueueCapacities queueCapacities, QueueCapacities parentQueueCapacities, Set<String> nodeLabels, boolean isLegacyQueueMode) {
        for (String label : nodeLabels) {
            float maxCapacity;
            if (isLegacyQueueMode) {
                float capacity = Math.max(queueCapacities.getCapacity(label), queueCapacities.getNormalizedWeight(label));
                if (capacity > 0.0f) {
                    queueCapacities.setAbsoluteCapacity(label, capacity * (parentQueueCapacities == null ? 1.0f : parentQueueCapacities.getAbsoluteCapacity(label)));
                }
            } else {
                queueCapacities.setAbsoluteCapacity(label, queueCapacities.getCapacity(label) * (parentQueueCapacities == null ? 1.0f : parentQueueCapacities.getAbsoluteCapacity(label)));
            }
            if (!((maxCapacity = queueCapacities.getMaximumCapacity(label)) > 0.0f)) continue;
            queueCapacities.setAbsoluteMaximumCapacity(label, maxCapacity * (parentQueueCapacities == null ? 1.0f : parentQueueCapacities.getAbsoluteMaximumCapacity(label)));
        }
    }
}

