/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.OptionalLong;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.regionserver.DataTiering;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CellTSTiering
implements DataTiering {
    private static final Logger LOG = LoggerFactory.getLogger(CellTSTiering.class);

    @Override
    public long getTimestamp(HStoreFile hStoreFile) {
        OptionalLong maxTimestamp = hStoreFile.getMaximumTimestamp();
        if (!maxTimestamp.isPresent()) {
            LOG.debug("Maximum timestamp not present for {}", (Object)hStoreFile.getPath());
            return Long.MAX_VALUE;
        }
        return maxTimestamp.getAsLong();
    }

    @Override
    public long getTimestamp(HFileInfo hFileInfo) {
        try {
            byte[] hFileTimeRange = hFileInfo.get(HStoreFile.TIMERANGE_KEY);
            if (hFileTimeRange == null) {
                LOG.debug("Timestamp information not found for file: {}", (Object)hFileInfo.getHFileContext().getHFileName());
                return Long.MAX_VALUE;
            }
            return TimeRangeTracker.parseFrom(hFileTimeRange).getMax();
        }
        catch (IOException e) {
            LOG.error("Error occurred while reading the timestamp metadata of file: {}", (Object)hFileInfo.getHFileContext().getHFileName(), (Object)e);
            return Long.MAX_VALUE;
        }
    }
}

