/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.ByteRangeUtils;
import org.apache.hadoop.hbase.util.SimpleByteRange;
import org.apache.hadoop.hbase.util.SimpleMutableByteRange;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestByteRangeUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteRangeUtils.class);

    @Test
    public void testNumEqualPrefixBytes() {
        Assert.assertEquals((long)0L, (long)ByteRangeUtils.numEqualPrefixBytes((ByteRange)new SimpleByteRange(new byte[]{1, 2, 3}), (ByteRange)new SimpleByteRange(new byte[]{4, 5, 6}), (int)1));
        Assert.assertEquals((long)2L, (long)ByteRangeUtils.numEqualPrefixBytes((ByteRange)new SimpleByteRange(new byte[]{1, 2, 3}), (ByteRange)new SimpleByteRange(new byte[]{0, 1, 2}), (int)1));
    }

    @Test
    public void testCopyToNewArrays() {
        Assert.assertEquals(new ArrayList(), (Object)ByteRangeUtils.copyToNewArrays(null));
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])((byte[])ByteRangeUtils.copyToNewArrays(new ArrayList<SimpleByteRange>(Arrays.asList(new SimpleByteRange(new byte[]{1, 2, 3}), new SimpleByteRange(new byte[]{4, 5, 6})))).get(0)));
        Assert.assertArrayEquals((byte[])new byte[]{4, 5, 6}, (byte[])((byte[])ByteRangeUtils.copyToNewArrays(new ArrayList<SimpleByteRange>(Arrays.asList(new SimpleByteRange(new byte[]{1, 2, 3}), new SimpleByteRange(new byte[]{4, 5, 6})))).get(1)));
    }

    @Test
    public void testFromArrays() {
        Assert.assertEquals(new ArrayList(), (Object)ByteRangeUtils.fromArrays(null));
        Assert.assertEquals(new ArrayList<SimpleMutableByteRange>(Arrays.asList(new SimpleMutableByteRange(new byte[]{1, 2, 3}), new SimpleMutableByteRange(new byte[]{4, 5, 6}))), (Object)ByteRangeUtils.fromArrays(new ArrayList(Arrays.asList({1, 2, 3}, {4, 5, 6}))));
    }
}

