/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public enum IndexBlockEncoding {
    NONE(0, null),
    PREFIX_TREE(1, null);

    private final short id;
    private final byte[] idInBytes;
    private final String encoderCls;
    public static final int ID_SIZE = 2;
    private static IndexBlockEncoding[] idArray;

    private IndexBlockEncoding(int id, String encoderClsName) {
        if (id < 0 || id > 127) {
            throw new AssertionError((Object)("Data block encoding algorithm id is out of range: " + id));
        }
        this.id = (short)id;
        this.idInBytes = Bytes.toBytes(this.id);
        if (this.idInBytes.length != 2) {
            throw new RuntimeException("Unexpected length of encoder ID byte representation: " + Bytes.toStringBinary(this.idInBytes));
        }
        this.encoderCls = encoderClsName;
    }

    public byte[] getNameInBytes() {
        return Bytes.toBytes(this.toString());
    }

    public short getId() {
        return this.id;
    }

    public void writeIdInBytes(OutputStream stream) throws IOException {
        stream.write(this.idInBytes);
    }

    public void writeIdInBytes(byte[] dest, int offset) throws IOException {
        System.arraycopy(this.idInBytes, 0, dest, offset, 2);
    }

    public static String getNameFromId(short encoderId) {
        return IndexBlockEncoding.getEncodingById(encoderId).toString();
    }

    public static IndexBlockEncoding getEncodingById(short indexBlockEncodingId) {
        IndexBlockEncoding algorithm = null;
        if (indexBlockEncodingId >= 0 && indexBlockEncodingId <= 127) {
            algorithm = idArray[indexBlockEncodingId];
        }
        if (algorithm == null) {
            throw new IllegalArgumentException(String.format("There is no index block encoder for given id '%d'", indexBlockEncodingId));
        }
        return algorithm;
    }

    static {
        idArray = new IndexBlockEncoding[128];
        for (IndexBlockEncoding algo : IndexBlockEncoding.values()) {
            if (idArray[algo.id] != null) {
                throw new RuntimeException(String.format("Two data block encoder algorithms '%s' and '%s' have the same id %d", idArray[algo.id].toString(), algo.toString(), (int)algo.id));
            }
            IndexBlockEncoding.idArray[algo.id] = algo;
        }
    }
}

