/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.SteppingSplitPolicy;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public abstract class RegionSplitPolicy
extends Configured {
    private static final Class<? extends RegionSplitPolicy> DEFAULT_SPLIT_POLICY_CLASS = SteppingSplitPolicy.class;
    protected HRegion region;

    protected void configureForRegion(HRegion region) {
        Preconditions.checkState(this.region == null, "Policy already configured for region {}", (Object)this.region);
        this.region = region;
    }

    protected abstract boolean shouldSplit();

    protected boolean canSplit() {
        return !this.region.getRegionInfo().isMetaRegion() && this.region.isAvailable() && !TableName.NAMESPACE_TABLE_NAME.equals(this.region.getRegionInfo().getTable()) && this.region.getStores().stream().allMatch(HStore::canSplit);
    }

    protected byte[] getSplitPoint() {
        List<HStore> stores = this.region.getStores();
        byte[] splitPointFromLargestStore = null;
        long largestStoreSize = 0L;
        for (HStore s2 : stores) {
            Optional<byte[]> splitPoint = s2.getSplitPoint();
            long storeSize = s2.getSize();
            if (!splitPoint.isPresent() || largestStoreSize >= storeSize) continue;
            splitPointFromLargestStore = splitPoint.get();
            largestStoreSize = storeSize;
        }
        return splitPointFromLargestStore;
    }

    public static RegionSplitPolicy create(HRegion region, Configuration conf) throws IOException {
        Preconditions.checkNotNull(region, "Region should not be null.");
        Class<? extends RegionSplitPolicy> clazz = RegionSplitPolicy.getSplitPolicyClass(region.getTableDescriptor(), conf);
        RegionSplitPolicy policy = (RegionSplitPolicy)((Object)ReflectionUtils.newInstance(clazz, (Configuration)conf));
        policy.configureForRegion(region);
        return policy;
    }

    public static Class<? extends RegionSplitPolicy> getSplitPolicyClass(TableDescriptor htd, Configuration conf) throws IOException {
        String className = htd.getRegionSplitPolicyClassName();
        if (className == null) {
            className = conf.get("hbase.regionserver.region.split.policy", DEFAULT_SPLIT_POLICY_CLASS.getName());
        }
        try {
            Class<RegionSplitPolicy> clazz = Class.forName(className).asSubclass(RegionSplitPolicy.class);
            return clazz;
        }
        catch (Exception e) {
            throw new IOException("Unable to load configured region split policy '" + className + "' for table '" + htd.getTableName() + "'", e);
        }
    }

    protected boolean skipStoreFileRangeCheck(String familyName) {
        return false;
    }
}

