/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.HasMasterServices;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RSGroupAdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.TableProtos;
import org.apache.hadoop.hbase.rsgroup.RSGroupAdminServer;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManagerImpl;
import org.apache.hadoop.hbase.rsgroup.RSGroupProtobufUtil;
import org.apache.hadoop.hbase.rsgroup.RSGroupUtil;
import org.apache.hadoop.hbase.rsgroup.RSGroupableBalancer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CoreCoprocessor
@InterfaceAudience.Private
public class RSGroupAdminEndpoint
implements MasterCoprocessor,
MasterObserver {
    private static final Logger LOG = LoggerFactory.getLogger(RSGroupAdminEndpoint.class);
    private MasterServices master = null;
    private RSGroupInfoManager groupInfoManager;
    private RSGroupAdminServer groupAdminServer;
    private final RSGroupAdminProtos.RSGroupAdminService groupAdminService = new RSGroupAdminServiceImpl();
    private AccessChecker accessChecker;
    private UserProvider userProvider;

    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof HasMasterServices)) {
            throw new IOException("Does not implement HMasterServices");
        }
        this.master = ((HasMasterServices)env).getMasterServices();
        this.groupInfoManager = RSGroupInfoManagerImpl.getInstance(this.master);
        this.groupAdminServer = new RSGroupAdminServer(this.master, this.groupInfoManager);
        Class clazz = this.master.getConfiguration().getClass("hbase.master.loadbalancer.class", null);
        if (!RSGroupableBalancer.class.isAssignableFrom(clazz)) {
            throw new IOException("Configured balancer does not support RegionServer groups.");
        }
        this.accessChecker = ((HasMasterServices)env).getMasterServices().getAccessChecker();
        this.userProvider = UserProvider.instantiate((Configuration)env.getConfiguration());
    }

    public void stop(CoprocessorEnvironment env) {
    }

    public Iterable<Service> getServices() {
        return Collections.singleton(this.groupAdminService);
    }

    public Optional<MasterObserver> getMasterObserver() {
        return Optional.of(this);
    }

    RSGroupInfoManager getGroupInfoManager() {
        return this.groupInfoManager;
    }

    RSGroupAdminServer getGroupAdminServer() {
        return this.groupAdminServer;
    }

    boolean rsgroupHasServersOnline(TableDescriptor desc) throws IOException {
        String groupName;
        try {
            groupName = this.master.getClusterSchema().getNamespace(desc.getTableName().getNamespaceAsString()).getConfigurationValue("hbase.rsgroup.name");
            if (groupName == null) {
                groupName = "default";
            }
        }
        catch (MasterNotRunningException | PleaseHoldException e) {
            LOG.info("Master has not initialized yet; temporarily using default RSGroup 'default' for deploy of system table");
            groupName = "default";
        }
        RSGroupInfo rsGroupInfo = this.groupAdminServer.getRSGroupInfo(groupName);
        if (rsGroupInfo == null) {
            throw new ConstraintException("Default RSGroup (" + groupName + ") for this table's namespace does not exist.");
        }
        for (ServerName onlineServer : this.master.getServerManager().createDestinationServersList()) {
            if (!rsGroupInfo.getServers().contains(onlineServer.getAddress())) continue;
            return true;
        }
        return false;
    }

    void assignTableToGroup(TableDescriptor desc) throws IOException {
        RSGroupInfo rsGroupInfo = this.determineRSGroupInfoForTable(desc);
        if (rsGroupInfo == null) {
            throw new ConstraintException("Default RSGroup for this table " + desc.getTableName() + " does not exist.");
        }
        if (!rsGroupInfo.containsTable(desc.getTableName())) {
            LOG.debug("Pre-moving table " + desc.getTableName() + " to RSGroup " + rsGroupInfo.getName());
            this.groupAdminServer.moveTables(Sets.newHashSet((Object[])new TableName[]{desc.getTableName()}), rsGroupInfo.getName());
        }
    }

    public void preCreateTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableDescriptor desc, RegionInfo[] regions) throws IOException {
        if (desc.getTableName().isSystemTable()) {
            return;
        }
        this.moveTableToValidRSGroup(desc);
    }

    public void preModifyTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor currentDescriptor, TableDescriptor newDescriptor) throws IOException {
        if (!currentDescriptor.getRegionServerGroup().equals(newDescriptor.getRegionServerGroup())) {
            RSGroupInfo rsGroupInfo = this.determineRSGroupInfoForTable(newDescriptor);
            this.validateRSGroup(newDescriptor, rsGroupInfo);
        }
    }

    public void postCompletedModifyTableAction(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName, TableDescriptor oldDescriptor, TableDescriptor currentDescriptor) throws IOException {
        if (!oldDescriptor.getRegionServerGroup().equals(currentDescriptor.getRegionServerGroup())) {
            RSGroupInfo rsGroupInfo = this.determineRSGroupInfoForTable(currentDescriptor);
            this.moveTableToRSGroup(currentDescriptor, rsGroupInfo);
        }
    }

    private void moveTableToValidRSGroup(TableDescriptor desc) throws IOException {
        RSGroupInfo rsGroupInfo = this.determineRSGroupInfoForTable(desc);
        this.validateRSGroup(desc, rsGroupInfo);
        this.moveTableToRSGroup(desc, rsGroupInfo);
    }

    private void validateRSGroup(TableDescriptor desc, RSGroupInfo rsGroupInfo) throws IOException {
        if (rsGroupInfo == null) {
            throw new ConstraintException("Default RSGroup for this table " + desc.getTableName() + " does not exist.");
        }
        if (!RSGroupUtil.rsGroupHasOnlineServer(this.master, rsGroupInfo)) {
            throw new HBaseIOException("No online servers in the rsgroup " + rsGroupInfo.getName() + " which table " + desc.getTableName().getNameAsString() + " belongs to");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTableToRSGroup(TableDescriptor desc, RSGroupInfo rsGroupInfo) throws IOException {
        if (!rsGroupInfo.containsTable(desc.getTableName())) {
            RSGroupInfoManager rSGroupInfoManager = this.groupInfoManager;
            synchronized (rSGroupInfoManager) {
                this.groupInfoManager.moveTables(Collections.singleton(desc.getTableName()), rsGroupInfo.getName());
            }
        }
    }

    private RSGroupInfo determineRSGroupInfoForTable(TableDescriptor desc) throws IOException {
        Optional optGroupNameOfTable = desc.getRegionServerGroup();
        if (optGroupNameOfTable.isPresent()) {
            RSGroupInfo rsGroup = this.groupInfoManager.getRSGroup((String)optGroupNameOfTable.get());
            if (rsGroup == null) {
                throw new ConstraintException("Region server group " + (String)optGroupNameOfTable.get() + " does not exist.");
            }
            return rsGroup;
        }
        return this.groupInfoManager.determineRSGroupInfoForTable(desc.getTableName());
    }

    public void postDeleteTable(ObserverContext<MasterCoprocessorEnvironment> ctx, TableName tableName) throws IOException {
        try {
            RSGroupInfo group = this.groupAdminServer.getRSGroupInfoOfTable(tableName);
            if (group != null) {
                LOG.debug(String.format("Removing deleted table '%s' from rsgroup '%s'", tableName, group.getName()));
                this.groupAdminServer.moveTables(Sets.newHashSet((Object[])new TableName[]{tableName}), null);
            }
        }
        catch (IOException ex) {
            LOG.debug("Failed to perform RSGroup information cleanup for table: " + tableName, (Throwable)ex);
        }
    }

    public void preCreateNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        String group = ns.getConfigurationValue("hbase.rsgroup.name");
        if (group != null && this.groupAdminServer.getRSGroupInfo(group) == null) {
            throw new ConstraintException("Region server group " + group + " does not exist.");
        }
    }

    public void preModifyNamespace(ObserverContext<MasterCoprocessorEnvironment> ctx, NamespaceDescriptor ns) throws IOException {
        this.preCreateNamespace(ctx, ns);
    }

    public void preCloneSnapshot(ObserverContext<MasterCoprocessorEnvironment> ctx, SnapshotDescription snapshot, TableDescriptor desc) throws IOException {
        this.assignTableToGroup(desc);
    }

    public void postClearDeadServers(ObserverContext<MasterCoprocessorEnvironment> ctx, List<ServerName> servers, List<ServerName> notClearedServers) throws IOException {
        Set<Address> clearedServer = servers.stream().filter(server -> !notClearedServers.contains(server)).map(ServerName::getAddress).collect(Collectors.toSet());
        if (!clearedServer.isEmpty()) {
            this.groupAdminServer.removeServers(clearedServer);
        }
    }

    public void checkPermission(String request) throws IOException {
        this.accessChecker.requirePermission(this.getActiveUser(), request, null, Permission.Action.ADMIN);
    }

    private User getActiveUser() throws IOException {
        Optional optionalUser = RpcServer.getRequestUser();
        if (optionalUser.isPresent()) {
            return (User)optionalUser.get();
        }
        return this.userProvider.getCurrent();
    }

    private class RSGroupAdminServiceImpl
    extends RSGroupAdminProtos.RSGroupAdminService {
        private RSGroupAdminServiceImpl() {
        }

        @Override
        public void getRSGroupInfo(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoRequest request, RpcCallback<RSGroupAdminProtos.GetRSGroupInfoResponse> done) {
            RSGroupAdminProtos.GetRSGroupInfoResponse.Builder builder = RSGroupAdminProtos.GetRSGroupInfoResponse.newBuilder();
            String groupName = request.getRSGroupName();
            LOG.info(RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix() + " initiates rsgroup info retrieval, group=" + groupName);
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preGetRSGroupInfo(groupName);
                }
                RSGroupAdminEndpoint.this.checkPermission("getRSGroupInfo");
                RSGroupInfo rsGroupInfo = RSGroupAdminEndpoint.this.groupAdminServer.getRSGroupInfo(groupName);
                if (rsGroupInfo != null) {
                    builder.setRSGroupInfo(RSGroupProtobufUtil.toProtoGroupInfo(rsGroupInfo));
                }
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postGetRSGroupInfo(groupName);
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void getRSGroupInfoOfTable(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoOfTableRequest request, RpcCallback<RSGroupAdminProtos.GetRSGroupInfoOfTableResponse> done) {
            RSGroupAdminProtos.GetRSGroupInfoOfTableResponse.Builder builder = RSGroupAdminProtos.GetRSGroupInfoOfTableResponse.newBuilder();
            TableName tableName = ProtobufUtil.toTableName((TableProtos.TableName)request.getTableName());
            LOG.info(RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix() + " initiates rsgroup info retrieval, table=" + tableName);
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preGetRSGroupInfoOfTable(tableName);
                }
                RSGroupAdminEndpoint.this.checkPermission("getRSGroupInfoOfTable");
                RSGroupInfo RSGroupInfo2 = RSGroupAdminEndpoint.this.groupAdminServer.getRSGroupInfoOfTable(tableName);
                if (RSGroupInfo2 != null) {
                    builder.setRSGroupInfo(RSGroupProtobufUtil.toProtoGroupInfo(RSGroupInfo2));
                }
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postGetRSGroupInfoOfTable(tableName);
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void moveServers(RpcController controller, RSGroupAdminProtos.MoveServersRequest request, RpcCallback<RSGroupAdminProtos.MoveServersResponse> done) {
            RSGroupAdminProtos.MoveServersResponse.Builder builder = RSGroupAdminProtos.MoveServersResponse.newBuilder();
            HashSet hostPorts = Sets.newHashSet();
            for (HBaseProtos.ServerName el : request.getServersList()) {
                hostPorts.add(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
            }
            LOG.info(RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix() + " move servers " + hostPorts + " to rsgroup " + request.getTargetGroup());
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preMoveServers((Set)hostPorts, request.getTargetGroup());
                }
                RSGroupAdminEndpoint.this.checkPermission("moveServers");
                RSGroupAdminEndpoint.this.groupAdminServer.moveServers(hostPorts, request.getTargetGroup());
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postMoveServers((Set)hostPorts, request.getTargetGroup());
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void moveTables(RpcController controller, RSGroupAdminProtos.MoveTablesRequest request, RpcCallback<RSGroupAdminProtos.MoveTablesResponse> done) {
            RSGroupAdminProtos.MoveTablesResponse.Builder builder = RSGroupAdminProtos.MoveTablesResponse.newBuilder();
            HashSet<TableName> tables = new HashSet<TableName>(request.getTableNameList().size());
            for (TableProtos.TableName tableName : request.getTableNameList()) {
                tables.add(ProtobufUtil.toTableName((TableProtos.TableName)tableName));
            }
            LOG.info(RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix() + " move tables " + tables + " to rsgroup " + request.getTargetGroup());
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preMoveTables(tables, request.getTargetGroup());
                }
                RSGroupAdminEndpoint.this.checkPermission("moveTables");
                RSGroupAdminEndpoint.this.groupAdminServer.moveTables(tables, request.getTargetGroup());
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postMoveTables(tables, request.getTargetGroup());
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void addRSGroup(RpcController controller, RSGroupAdminProtos.AddRSGroupRequest request, RpcCallback<RSGroupAdminProtos.AddRSGroupResponse> done) {
            RSGroupAdminProtos.AddRSGroupResponse.Builder builder = RSGroupAdminProtos.AddRSGroupResponse.newBuilder();
            LOG.info(RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix() + " add rsgroup " + request.getRSGroupName());
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preAddRSGroup(request.getRSGroupName());
                }
                RSGroupAdminEndpoint.this.checkPermission("addRSGroup");
                RSGroupAdminEndpoint.this.groupAdminServer.addRSGroup(request.getRSGroupName());
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postAddRSGroup(request.getRSGroupName());
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void removeRSGroup(RpcController controller, RSGroupAdminProtos.RemoveRSGroupRequest request, RpcCallback<RSGroupAdminProtos.RemoveRSGroupResponse> done) {
            RSGroupAdminProtos.RemoveRSGroupResponse.Builder builder = RSGroupAdminProtos.RemoveRSGroupResponse.newBuilder();
            LOG.info(RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix() + " remove rsgroup " + request.getRSGroupName());
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preRemoveRSGroup(request.getRSGroupName());
                }
                RSGroupAdminEndpoint.this.checkPermission("removeRSGroup");
                RSGroupAdminEndpoint.this.groupAdminServer.removeRSGroup(request.getRSGroupName());
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postRemoveRSGroup(request.getRSGroupName());
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void balanceRSGroup(RpcController controller, RSGroupAdminProtos.BalanceRSGroupRequest request, RpcCallback<RSGroupAdminProtos.BalanceRSGroupResponse> done) {
            BalanceRequest balanceRequest = RSGroupProtobufUtil.toBalanceRequest(request);
            RSGroupAdminProtos.BalanceRSGroupResponse.Builder builder = RSGroupAdminProtos.BalanceRSGroupResponse.newBuilder().setBalanceRan(false);
            LOG.info(RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix() + " balance rsgroup, group=" + request.getRSGroupName());
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preBalanceRSGroup(request.getRSGroupName(), balanceRequest);
                }
                RSGroupAdminEndpoint.this.checkPermission("balanceRSGroup");
                BalanceResponse response = RSGroupAdminEndpoint.this.groupAdminServer.balanceRSGroup(request.getRSGroupName(), balanceRequest);
                RSGroupProtobufUtil.populateBalanceRSGroupResponse(builder, response);
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postBalanceRSGroup(request.getRSGroupName(), balanceRequest, response);
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void listRSGroupInfos(RpcController controller, RSGroupAdminProtos.ListRSGroupInfosRequest request, RpcCallback<RSGroupAdminProtos.ListRSGroupInfosResponse> done) {
            RSGroupAdminProtos.ListRSGroupInfosResponse.Builder builder = RSGroupAdminProtos.ListRSGroupInfosResponse.newBuilder();
            LOG.info(RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix() + " list rsgroup");
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preListRSGroups();
                }
                RSGroupAdminEndpoint.this.checkPermission("listRSGroup");
                for (RSGroupInfo RSGroupInfo2 : RSGroupAdminEndpoint.this.groupAdminServer.listRSGroups()) {
                    builder.addRSGroupInfo(RSGroupProtobufUtil.toProtoGroupInfo(RSGroupInfo2));
                }
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postListRSGroups();
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void getRSGroupInfoOfServer(RpcController controller, RSGroupAdminProtos.GetRSGroupInfoOfServerRequest request, RpcCallback<RSGroupAdminProtos.GetRSGroupInfoOfServerResponse> done) {
            RSGroupAdminProtos.GetRSGroupInfoOfServerResponse.Builder builder = RSGroupAdminProtos.GetRSGroupInfoOfServerResponse.newBuilder();
            Address hp = Address.fromParts((String)request.getServer().getHostName(), (int)request.getServer().getPort());
            LOG.info(RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix() + " initiates rsgroup info retrieval, server=" + hp);
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preGetRSGroupInfoOfServer(hp);
                }
                RSGroupAdminEndpoint.this.checkPermission("getRSGroupInfoOfServer");
                RSGroupInfo info = RSGroupAdminEndpoint.this.groupAdminServer.getRSGroupOfServer(hp);
                if (info != null) {
                    builder.setRSGroupInfo(RSGroupProtobufUtil.toProtoGroupInfo(info));
                }
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postGetRSGroupInfoOfServer(hp);
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void moveServersAndTables(RpcController controller, RSGroupAdminProtos.MoveServersAndTablesRequest request, RpcCallback<RSGroupAdminProtos.MoveServersAndTablesResponse> done) {
            RSGroupAdminProtos.MoveServersAndTablesResponse.Builder builder = RSGroupAdminProtos.MoveServersAndTablesResponse.newBuilder();
            HashSet hostPorts = Sets.newHashSet();
            for (HBaseProtos.ServerName serverName : request.getServersList()) {
                hostPorts.add(Address.fromParts((String)serverName.getHostName(), (int)serverName.getPort()));
            }
            HashSet<TableName> tables = new HashSet<TableName>(request.getTableNameList().size());
            for (TableProtos.TableName tableName : request.getTableNameList()) {
                tables.add(ProtobufUtil.toTableName((TableProtos.TableName)tableName));
            }
            LOG.info(RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix() + " move servers " + hostPorts + " and tables " + tables + " to rsgroup" + request.getTargetGroup());
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preMoveServersAndTables((Set)hostPorts, tables, request.getTargetGroup());
                }
                RSGroupAdminEndpoint.this.checkPermission("moveServersAndTables");
                RSGroupAdminEndpoint.this.groupAdminServer.moveServersAndTables(hostPorts, tables, request.getTargetGroup());
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postMoveServersAndTables((Set)hostPorts, tables, request.getTargetGroup());
                }
            }
            catch (IOException iOException) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)iOException);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void removeServers(RpcController controller, RSGroupAdminProtos.RemoveServersRequest request, RpcCallback<RSGroupAdminProtos.RemoveServersResponse> done) {
            RSGroupAdminProtos.RemoveServersResponse.Builder builder = RSGroupAdminProtos.RemoveServersResponse.newBuilder();
            HashSet servers = Sets.newHashSet();
            for (HBaseProtos.ServerName el : request.getServersList()) {
                servers.add(Address.fromParts((String)el.getHostName(), (int)el.getPort()));
            }
            LOG.info(RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix() + " remove decommissioned servers from rsgroup: " + servers);
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preRemoveServers((Set)servers);
                }
                RSGroupAdminEndpoint.this.checkPermission("removeServers");
                RSGroupAdminEndpoint.this.groupAdminServer.removeServers(servers);
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postRemoveServers((Set)servers);
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void renameRSGroup(RpcController controller, RSGroupAdminProtos.RenameRSGroupRequest request, RpcCallback<RSGroupAdminProtos.RenameRSGroupResponse> done) {
            String oldRSGroup = request.getOldRsgroupName();
            String newRSGroup = request.getNewRsgroupName();
            LOG.info("{} rename rsgroup from {} to {}", new Object[]{RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix(), oldRSGroup, newRSGroup});
            RSGroupAdminProtos.RenameRSGroupResponse.Builder builder = RSGroupAdminProtos.RenameRSGroupResponse.newBuilder();
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preRenameRSGroup(oldRSGroup, newRSGroup);
                }
                RSGroupAdminEndpoint.this.checkPermission("renameRSGroup");
                RSGroupAdminEndpoint.this.groupAdminServer.renameRSGroup(oldRSGroup, newRSGroup);
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postRenameRSGroup(oldRSGroup, newRSGroup);
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }

        @Override
        public void updateRSGroupConfig(RpcController controller, RSGroupAdminProtos.UpdateRSGroupConfigRequest request, RpcCallback<RSGroupAdminProtos.UpdateRSGroupConfigResponse> done) {
            RSGroupAdminProtos.UpdateRSGroupConfigResponse.Builder builder = RSGroupAdminProtos.UpdateRSGroupConfigResponse.newBuilder();
            String groupName = request.getGroupName();
            HashMap configuration = Maps.newHashMap();
            request.getConfigurationList().forEach(p -> configuration.put(p.getName(), p.getValue()));
            LOG.info("{} update rsgroup {} configuration {}", new Object[]{RSGroupAdminEndpoint.this.master.getClientIdAuditPrefix(), groupName, configuration});
            try {
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().preUpdateRSGroupConfig(groupName, (Map)configuration);
                }
                RSGroupAdminEndpoint.this.checkPermission("updateRSGroupConfig");
                RSGroupAdminEndpoint.this.groupAdminServer.updateRSGroupConfig(groupName, configuration);
                if (RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost() != null) {
                    RSGroupAdminEndpoint.this.master.getMasterCoprocessorHost().postUpdateRSGroupConfig(groupName, (Map)configuration);
                }
            }
            catch (IOException e) {
                CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            }
            done.run((Object)builder.build());
        }
    }
}

