/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.junit.rules.ExternalResource;

public final class ConnectionRule
extends ExternalResource {
    private final Supplier<Connection> connectionSupplier;
    private final Supplier<CompletableFuture<AsyncConnection>> asyncConnectionSupplier;
    private Connection connection;
    private AsyncConnection asyncConnection;

    public static ConnectionRule createConnectionRule(Supplier<Connection> connectionSupplier) {
        return new ConnectionRule(connectionSupplier, null);
    }

    public static ConnectionRule createAsyncConnectionRule(Supplier<CompletableFuture<AsyncConnection>> asyncConnectionSupplier) {
        return new ConnectionRule(null, asyncConnectionSupplier);
    }

    public static ConnectionRule createConnectionRule(Supplier<Connection> connectionSupplier, Supplier<CompletableFuture<AsyncConnection>> asyncConnectionSupplier) {
        return new ConnectionRule(connectionSupplier, asyncConnectionSupplier);
    }

    private ConnectionRule(Supplier<Connection> connectionSupplier, Supplier<CompletableFuture<AsyncConnection>> asyncConnectionSupplier) {
        this.connectionSupplier = connectionSupplier;
        this.asyncConnectionSupplier = asyncConnectionSupplier;
    }

    public Connection getConnection() {
        if (this.connection == null) {
            throw new IllegalStateException("ConnectionRule not initialized with a synchronous connection.");
        }
        return this.connection;
    }

    public AsyncConnection getAsyncConnection() {
        if (this.asyncConnection == null) {
            throw new IllegalStateException("ConnectionRule not initialized with an asynchronous connection.");
        }
        return this.asyncConnection;
    }

    protected void before() throws Throwable {
        if (this.connectionSupplier != null) {
            this.connection = this.connectionSupplier.get();
        }
        if (this.asyncConnectionSupplier != null) {
            this.asyncConnection = this.asyncConnectionSupplier.get().join();
        }
    }

    protected void after() {
        CompletableFuture<Void> closeConnection = CompletableFuture.runAsync(() -> {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        CompletableFuture<Void> closeAsyncConnection = CompletableFuture.runAsync(() -> {
            if (this.asyncConnection != null) {
                try {
                    this.asyncConnection.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        CompletableFuture.allOf(closeConnection, closeAsyncConnection).join();
    }
}

