/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.TestAdminBase;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestAdmin4
extends TestAdminBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAdmin4.class);

    @Test
    public void testDecommissionAndStopRegionServers() throws Exception {
        List decommissionedRegionServers = ADMIN.listDecommissionedRegionServers();
        Assert.assertTrue((boolean)decommissionedRegionServers.isEmpty());
        ArrayList clusterRegionServers = new ArrayList(ADMIN.getRegionServers(true));
        ArrayList serversToDecommission = new ArrayList();
        serversToDecommission.add(clusterRegionServers.get(0));
        ADMIN.decommissionRegionServers(serversToDecommission, true);
        Assert.assertEquals((long)1L, (long)ADMIN.listDecommissionedRegionServers().size());
        ServerName serverName = (ServerName)serversToDecommission.get(0);
        ADMIN.stopRegionServer(serverName.getHostname() + ":" + serverName.getPort());
        Assert.assertNotEquals((String)"RS not removed from decommissioned list", (long)-1L, (long)TEST_UTIL.waitFor(10000L, () -> ADMIN.listDecommissionedRegionServers().isEmpty()));
        ZKWatcher zkw = TEST_UTIL.getZooKeeperWatcher();
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)zkw, (String)ZNodePaths.joinZNode((String)zkw.getZNodePaths().drainingZNode, (String)serverName.getServerName())));
    }

    @Test
    public void testReplicationPeerModificationSwitch() throws Exception {
        Assert.assertTrue((boolean)ADMIN.isReplicationPeerModificationEnabled());
        try {
            Assert.assertTrue((boolean)ADMIN.replicationPeerModificationSwitch(false));
            IOException error = (IOException)Assert.assertThrows(IOException.class, () -> ADMIN.addReplicationPeer("peer", ReplicationPeerConfig.newBuilder().setClusterKey(TEST_UTIL.getClusterKey() + "-test").build()));
            MatcherAssert.assertThat((Object)error.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Replication peer modification disabled"));
            Assert.assertFalse((boolean)ADMIN.replicationPeerModificationSwitch(true));
        }
        finally {
            ADMIN.replicationPeerModificationSwitch(true);
        }
    }
}

