/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestConnectionAttributes {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConnectionAttributes.class);
    private static final Map<String, byte[]> CONNECTION_ATTRIBUTES = new HashMap<String, byte[]>();
    private static final byte[] FAMILY;
    private static final TableName TABLE_NAME;
    private static final HBaseTestingUtility TEST_UTIL;
    private static MiniHBaseCluster cluster;

    @BeforeClass
    public static void setUp() throws Exception {
        cluster = TEST_UTIL.startMiniCluster(1);
        Table table = TEST_UTIL.createTable(TABLE_NAME, (byte[][])new byte[][]{FAMILY}, 1, 65536, AttributesCoprocessor.class.getName());
        table.close();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        cluster.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testConnectionHeaderOverwrittenAttributesRemain() throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf, null, (User)AuthUtil.loginClient((Configuration)conf), CONNECTION_ATTRIBUTES);
             Table table = conn.getTable(TABLE_NAME);){
            byte[] bytes = new byte[300];
            new Random().nextBytes(bytes);
            Result result = table.get(new Get(bytes));
            Assert.assertEquals((long)CONNECTION_ATTRIBUTES.size(), (long)result.size());
            for (Map.Entry<String, byte[]> attr : CONNECTION_ATTRIBUTES.entrySet()) {
                byte[] val = result.getValue(FAMILY, Bytes.toBytes((String)attr.getKey()));
                Assert.assertEquals((Object)Bytes.toStringBinary((byte[])attr.getValue()), (Object)Bytes.toStringBinary((byte[])val));
            }
        }
    }

    static {
        CONNECTION_ATTRIBUTES.put("clientId", Bytes.toBytes((String)"foo"));
        FAMILY = Bytes.toBytes((String)"0");
        TABLE_NAME = TableName.valueOf((String)"testConnectionAttributes");
        TEST_UTIL = new HBaseTestingUtility();
    }

    public static class AttributesCoprocessor
    implements RegionObserver,
    RegionCoprocessor {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> result) throws IOException {
            RpcCall rpcCall = (RpcCall)RpcServer.getCurrentCall().get();
            for (Map.Entry attr : rpcCall.getConnectionAttributes().entrySet()) {
                result.add((Cell)((RegionCoprocessorEnvironment)c.getEnvironment()).getCellBuilder().clear().setRow(get.getRow()).setFamily(FAMILY).setQualifier(Bytes.toBytes((String)((String)attr.getKey()))).setValue((byte[])attr.getValue()).setType(Cell.Type.Put).setTimestamp(1L).build());
            }
            result.sort((Comparator<Cell>)CellComparator.getInstance());
            c.bypass();
        }
    }
}

