/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ServerRemoteProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.regionserver.ReloadQuotasCallable;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hbase.thirdparty.com.google.common.base.Throwables;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReloadQuotasProcedure
extends ServerRemoteProcedure
implements ServerProcedureInterface {
    public ReloadQuotasProcedure() {
    }

    public ReloadQuotasProcedure(ServerName targetServer) {
        this.targetServer = targetServer;
    }

    @Override
    protected boolean complete(MasterProcedureEnv env, Throwable error) {
        if (error != null && this.containsCause(error, ClassNotFoundException.class)) {
            LOG.warn("Failed to reload quotas on server {}, but will allow this procedure to complete. The RegionServer may be on an older version of HBase that does not support ReloadQuotasProcedure.", (Object)this.targetServer);
            return true;
        }
        if (error != null) {
            LOG.error("Failed to reload quotas on server {}", (Object)this.targetServer, (Object)error);
            return false;
        }
        return true;
    }

    boolean containsCause(Throwable t, Class<? extends Throwable> causeClass) {
        return Throwables.getCausalChain((Throwable)t).stream().anyMatch(causeClass::isInstance);
    }

    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.ReloadQuotasProcedureStateData.Builder builder = MasterProcedureProtos.ReloadQuotasProcedureStateData.newBuilder();
        if (this.remoteError != null) {
            ErrorHandlingProtos.ForeignExceptionMessage fem = ForeignExceptionUtil.toProtoForeignException((Throwable)this.remoteError);
            builder.setError(fem);
        }
        serializer.serialize((Message)builder.setTargetServer(ProtobufUtil.toServerName((ServerName)this.targetServer)).build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.ReloadQuotasProcedureStateData data = (MasterProcedureProtos.ReloadQuotasProcedureStateData)serializer.deserialize(MasterProcedureProtos.ReloadQuotasProcedureStateData.class);
        this.targetServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)data.getTargetServer());
        if (data.hasError()) {
            this.remoteError = ForeignExceptionUtil.toException((ErrorHandlingProtos.ForeignExceptionMessage)data.getError());
        }
    }

    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName serverName) {
        if (!serverName.equals((Object)this.targetServer)) {
            throw new IllegalArgumentException("ReloadQuotasProcedure#remoteCallBuild called with unexpected serverName: " + serverName + " != " + this.targetServer);
        }
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), ReloadQuotasCallable.class, new byte[0], env.getMasterServices().getMasterActiveTime()));
    }

    @Override
    public ServerName getServerName() {
        return this.targetServer;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return false;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.RELOAD_QUOTAS;
    }
}

