/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.InvalidHFileException;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StoreFileInfo
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFileInfo.class);
    public static final String HFILE_NAME_REGEX = "[0-9a-f]+(?:(?:_SeqId_[0-9]+_)|(?:_del))?";
    private static final Pattern HFILE_NAME_PATTERN = Pattern.compile("^([0-9a-f]+(?:(?:_SeqId_[0-9]+_)|(?:_del))?)");
    private static final Pattern REF_NAME_PATTERN = Pattern.compile(String.format("^(%s|%s)\\.(.+)$", "[0-9a-f]+(?:(?:_SeqId_[0-9]+_)|(?:_del))?", HFileLink.LINK_NAME_REGEX));
    public static final String STORE_FILE_READER_NO_READAHEAD = "hbase.store.reader.no-readahead";
    public static final boolean DEFAULT_STORE_FILE_READER_NO_READAHEAD = true;
    private Configuration conf;
    private final FileSystem fs;
    private HDFSBlocksDistribution hdfsBlocksDistribution = null;
    private HFileInfo hfileInfo;
    private final Reference reference;
    private final HFileLink link;
    private final Path initialPath;
    private RegionCoprocessorHost coprocessorHost;
    private long createdTimestamp;
    private long size;
    private final boolean primaryReplica;
    private final boolean noReadahead;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private static final String SEQ_ID_MARKER = "_SeqId_";
    private static final int SEQ_ID_MARKER_LENGTH = "_SeqId_".length();

    private StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus, Path initialPath, boolean primaryReplica, StoreFileTracker sft) throws IOException {
        assert (fs != null);
        assert (initialPath != null);
        assert (conf != null);
        this.fs = fs;
        this.conf = conf;
        this.initialPath = fs.makeQualified(initialPath);
        this.primaryReplica = primaryReplica;
        this.noReadahead = this.conf.getBoolean(STORE_FILE_READER_NO_READAHEAD, true);
        Path p = initialPath;
        if (HFileLink.isHFileLink(p)) {
            this.reference = null;
            this.link = HFileLink.buildFromHFileLinkPattern(conf, p);
            LOG.trace("{} is a link", (Object)p);
        } else if (StoreFileInfo.isReference(p)) {
            this.reference = sft.readReference(p);
            Path referencePath = StoreFileInfo.getReferredToFile(p);
            this.link = HFileLink.isHFileLink(referencePath) ? HFileLink.buildFromHFileLinkPattern(conf, referencePath) : null;
            LOG.trace("{} is a {} reference to {}", new Object[]{p, this.reference.getFileRegion(), referencePath});
        } else if (StoreFileInfo.isHFile(p) || StoreFileInfo.isMobFile(p) || StoreFileInfo.isMobRefFile(p)) {
            if (fileStatus != null) {
                this.createdTimestamp = fileStatus.getModificationTime();
                this.size = fileStatus.getLen();
            } else {
                FileStatus fStatus = fs.getFileStatus(initialPath);
                this.createdTimestamp = fStatus.getModificationTime();
                this.size = fStatus.getLen();
            }
            this.reference = null;
            this.link = null;
        } else {
            throw new IOException("path=" + p + " doesn't look like a valid StoreFile");
        }
    }

    public StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus, HFileLink link) {
        this(conf, fs, fileStatus, null, link);
    }

    public StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus, Reference reference) {
        this(conf, fs, fileStatus, reference, null);
    }

    public StoreFileInfo(Configuration conf, FileSystem fs, FileStatus fileStatus, Reference reference, HFileLink link) {
        this.fs = fs;
        this.conf = conf;
        this.primaryReplica = false;
        this.initialPath = fileStatus == null ? null : fileStatus.getPath();
        this.createdTimestamp = fileStatus == null ? 0L : fileStatus.getModificationTime();
        this.reference = reference;
        this.link = link;
        this.noReadahead = this.conf.getBoolean(STORE_FILE_READER_NO_READAHEAD, true);
    }

    public StoreFileInfo(Configuration conf, FileSystem fs, long createdTimestamp, Path initialPath, long size, Reference reference, HFileLink link, boolean primaryReplica) {
        this.fs = fs;
        this.conf = conf;
        this.primaryReplica = primaryReplica;
        this.initialPath = initialPath;
        this.createdTimestamp = createdTimestamp;
        this.size = size;
        this.reference = reference;
        this.link = link;
        this.noReadahead = this.conf.getBoolean(STORE_FILE_READER_NO_READAHEAD, true);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public long getSize() {
        return this.size;
    }

    public void setRegionCoprocessorHost(RegionCoprocessorHost coprocessorHost) {
        this.coprocessorHost = coprocessorHost;
    }

    public Reference getReference() {
        return this.reference;
    }

    public boolean isReference() {
        return this.reference != null;
    }

    public boolean isTopReference() {
        return this.reference != null && Reference.isTopFileRegion(this.reference.getFileRegion());
    }

    public boolean isLink() {
        return this.link != null && this.reference == null;
    }

    public HDFSBlocksDistribution getHDFSBlockDistribution() {
        return this.hdfsBlocksDistribution;
    }

    public StoreFileReader createReader(ReaderContext context, CacheConfig cacheConf) throws IOException {
        StoreFileReader reader = null;
        reader = this.reference != null ? new HalfStoreFileReader(context, this.hfileInfo, cacheConf, this.reference, this, this.conf) : new StoreFileReader(context, this.hfileInfo, cacheConf, this, this.conf);
        return reader;
    }

    ReaderContext createReaderContext(boolean doDropBehind, long readahead, ReaderContext.ReaderType type) throws IOException {
        FileStatus status;
        FSDataInputStreamWrapper in;
        if (this.link != null) {
            in = new FSDataInputStreamWrapper(this.fs, this.link, doDropBehind, readahead);
            status = this.link.getFileStatus(this.fs);
        } else if (this.reference != null) {
            Path referencePath = StoreFileInfo.getReferredToFile(this.getPath());
            try {
                in = new FSDataInputStreamWrapper(this.fs, referencePath, doDropBehind, readahead);
            }
            catch (FileNotFoundException fnfe) {
                FileNotFoundException newFnfe = new FileNotFoundException(this.toString());
                newFnfe.initCause(fnfe);
                throw newFnfe;
            }
            status = this.fs.getFileStatus(referencePath);
        } else {
            in = new FSDataInputStreamWrapper(this.fs, this.getPath(), doDropBehind, readahead);
            status = this.fs.getFileStatus(this.initialPath);
        }
        long length = status.getLen();
        ReaderContextBuilder contextBuilder = new ReaderContextBuilder().withInputStreamWrapper(in).withFileSize(length).withPrimaryReplicaReader(this.primaryReplica).withReaderType(type).withFileSystem(this.fs);
        if (this.reference != null) {
            contextBuilder.withFilePath(this.getPath());
        } else {
            contextBuilder.withFilePath(status.getPath());
        }
        return contextBuilder.build();
    }

    public HDFSBlocksDistribution computeHDFSBlocksDistribution(FileSystem fs) throws IOException {
        if (this.link != null) {
            FileNotFoundException exToThrow = null;
            for (int i = 0; i < this.link.getLocations().length; ++i) {
                try {
                    return this.computeHDFSBlocksDistributionInternal(fs);
                }
                catch (FileNotFoundException ex) {
                    exToThrow = ex;
                    continue;
                }
            }
            throw exToThrow;
        }
        return this.computeHDFSBlocksDistributionInternal(fs);
    }

    private HDFSBlocksDistribution computeHDFSBlocksDistributionInternal(FileSystem fs) throws IOException {
        FileStatus status = this.getReferencedFileStatus(fs);
        if (this.reference != null) {
            return StoreFileInfo.computeRefFileHDFSBlockDistribution(fs, this.reference, status);
        }
        return FSUtils.computeHDFSBlocksDistribution(fs, status, 0L, status.getLen());
    }

    public FileStatus getReferencedFileStatus(FileSystem fs) throws IOException {
        FileStatus status;
        if (this.reference != null) {
            if (this.link != null) {
                FileNotFoundException exToThrow = null;
                for (int i = 0; i < this.link.getLocations().length; ++i) {
                    try {
                        return this.link.getFileStatus(fs);
                    }
                    catch (FileNotFoundException ex) {
                        exToThrow = ex;
                        continue;
                    }
                }
                throw exToThrow;
            }
            Path referencePath = StoreFileInfo.getReferredToFile(this.getPath());
            status = fs.getFileStatus(referencePath);
        } else {
            if (this.link != null) {
                FileNotFoundException exToThrow = null;
                for (int i = 0; i < this.link.getLocations().length; ++i) {
                    try {
                        return this.link.getFileStatus(fs);
                    }
                    catch (FileNotFoundException ex) {
                        exToThrow = ex;
                        continue;
                    }
                }
                throw exToThrow;
            }
            status = fs.getFileStatus(this.initialPath);
        }
        return status;
    }

    public Path getPath() {
        return this.initialPath;
    }

    public FileStatus getFileStatus() throws IOException {
        return this.getReferencedFileStatus(this.fs);
    }

    public long getModificationTime() throws IOException {
        return this.getFileStatus().getModificationTime();
    }

    public String toString() {
        return this.getPath() + (this.isReference() ? "->" + StoreFileInfo.getReferredToFile(this.getPath()) + "-" + this.reference : "");
    }

    public static boolean hasBulkloadSeqId(Path path) {
        String fileName = path.getName();
        return fileName.contains(SEQ_ID_MARKER);
    }

    public static OptionalLong getBulkloadSeqId(Path path) {
        String fileName = path.getName();
        int startPos = fileName.indexOf(SEQ_ID_MARKER);
        if (startPos != -1) {
            String strVal = fileName.substring(startPos + SEQ_ID_MARKER_LENGTH, fileName.indexOf(95, startPos + SEQ_ID_MARKER_LENGTH));
            return OptionalLong.of(Long.parseLong(strVal));
        }
        return OptionalLong.empty();
    }

    public static String formatBulkloadSeqId(long seqId) {
        return SEQ_ID_MARKER + seqId + "_";
    }

    public static boolean isHFile(Path path) {
        return StoreFileInfo.isHFile(path.getName());
    }

    public static boolean isHFile(String fileName) {
        Matcher m = HFILE_NAME_PATTERN.matcher(fileName);
        return m.matches() && m.groupCount() > 0;
    }

    public static boolean isMobFile(Path path) {
        String fileName = path.getName();
        String[] parts = fileName.split("_");
        if (parts.length != 2) {
            return false;
        }
        Matcher m = HFILE_NAME_PATTERN.matcher(parts[0]);
        Matcher mm = HFILE_NAME_PATTERN.matcher(parts[1]);
        return m.matches() && mm.matches();
    }

    public static boolean isMobRefFile(Path path) {
        String fileName = path.getName();
        int lastIndex = fileName.lastIndexOf("_");
        if (lastIndex < 0) {
            return false;
        }
        String[] parts = new String[]{fileName.substring(0, lastIndex), fileName.substring(lastIndex + 1)};
        String name = parts[0] + "." + parts[1];
        Matcher m = REF_NAME_PATTERN.matcher(name);
        return m.matches() && m.groupCount() > 1;
    }

    public static boolean isReference(Path path) {
        return StoreFileInfo.isReference(path.getName());
    }

    public static boolean isReference(String name) {
        if (!name.contains(".")) {
            return false;
        }
        Matcher m = REF_NAME_PATTERN.matcher(name);
        return m.matches() && m.groupCount() > 1;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public static Path getReferredToFile(Path p) {
        Matcher m = REF_NAME_PATTERN.matcher(p.getName());
        if (m == null || !m.matches()) {
            LOG.warn("Failed match of store file name {}", (Object)p.toString());
            throw new IllegalArgumentException("Failed match of store file name " + p.toString());
        }
        String otherRegion = m.group(2);
        Path tableDir = p.getParent().getParent().getParent();
        String nameStrippedOfSuffix = m.group(1);
        LOG.trace("reference {} to region={} hfile={}", new Object[]{p, otherRegion, nameStrippedOfSuffix});
        return new Path(new Path(new Path(tableDir, otherRegion), p.getParent().getName()), nameStrippedOfSuffix);
    }

    public static Pair<String, String> getReferredToRegionAndFile(String referenceFile) {
        Matcher m = REF_NAME_PATTERN.matcher(referenceFile);
        if (m == null || !m.matches()) {
            LOG.warn("Failed match of store file name {}", (Object)referenceFile);
            throw new IllegalArgumentException("Failed match of store file name " + referenceFile);
        }
        String referencedRegion = m.group(2);
        String referencedFile = m.group(1);
        LOG.trace("reference {} to region={} file={}", new Object[]{referenceFile, referencedRegion, referencedFile});
        return new Pair((Object)referencedRegion, (Object)referencedFile);
    }

    public static boolean validateStoreFileName(String fileName) {
        if (HFileLink.isHFileLink(fileName) || StoreFileInfo.isReference(fileName)) {
            return true;
        }
        return !fileName.contains("-");
    }

    public static boolean isValid(FileStatus fileStatus) throws IOException {
        Path p = fileStatus.getPath();
        if (fileStatus.isDirectory()) {
            return false;
        }
        if (!HFileLink.isHFileLink(p) && fileStatus.getLen() <= 0L) {
            LOG.warn("Skipping {} because it is empty. HBASE-646 DATA LOSS?", (Object)p);
            return false;
        }
        return StoreFileInfo.validateStoreFileName(p.getName());
    }

    private static HDFSBlocksDistribution computeRefFileHDFSBlockDistribution(FileSystem fs, Reference reference, FileStatus status) throws IOException {
        if (status == null) {
            return null;
        }
        long start = 0L;
        long length = 0L;
        if (Reference.isTopFileRegion(reference.getFileRegion())) {
            start = status.getLen() / 2L;
            length = status.getLen() - status.getLen() / 2L;
        } else {
            start = 0L;
            length = status.getLen() / 2L;
        }
        return FSUtils.computeHDFSBlocksDistribution(fs, status, start, length);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (!(that instanceof StoreFileInfo)) {
            return false;
        }
        StoreFileInfo o = (StoreFileInfo)that;
        if (this.initialPath != null && o.initialPath == null) {
            return false;
        }
        if (this.initialPath == null && o.initialPath != null) {
            return false;
        }
        if (this.initialPath != o.initialPath && this.initialPath != null && !this.initialPath.equals((Object)o.initialPath)) {
            return false;
        }
        if (this.reference != null && o.reference == null) {
            return false;
        }
        if (this.reference == null && o.reference != null) {
            return false;
        }
        if (this.reference != o.reference && this.reference != null && !this.reference.equals(o.reference)) {
            return false;
        }
        if (this.link != null && o.link == null) {
            return false;
        }
        if (this.link == null && o.link != null) {
            return false;
        }
        return this.link == o.link || this.link == null || this.link.equals(o.link);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.reference == null ? 0 : this.reference.hashCode());
        hash = hash * 31 + (this.initialPath == null ? 0 : this.initialPath.hashCode());
        hash = hash * 31 + (this.link == null ? 0 : this.link.hashCode());
        return hash;
    }

    public String getActiveFileName() {
        if (this.reference != null || this.link == null) {
            return this.initialPath.getName();
        }
        return HFileLink.getReferencedHFileName(this.initialPath.getName());
    }

    FileSystem getFileSystem() {
        return this.fs;
    }

    boolean isNoReadahead() {
        return this.noReadahead;
    }

    public HFileInfo getHFileInfo() {
        return this.hfileInfo;
    }

    void initHDFSBlocksDistribution() throws IOException {
        this.hdfsBlocksDistribution = this.computeHDFSBlocksDistribution(this.fs);
    }

    StoreFileReader preStoreFileReaderOpen(ReaderContext context, CacheConfig cacheConf) throws IOException {
        StoreFileReader reader = null;
        if (this.coprocessorHost != null) {
            reader = this.coprocessorHost.preStoreFileReaderOpen(this.fs, this.getPath(), context.getInputStreamWrapper(), context.getFileSize(), cacheConf, this.reference);
        }
        return reader;
    }

    StoreFileReader postStoreFileReaderOpen(ReaderContext context, CacheConfig cacheConf, StoreFileReader reader) throws IOException {
        StoreFileReader res = reader;
        if (this.coprocessorHost != null) {
            res = this.coprocessorHost.postStoreFileReaderOpen(this.fs, this.getPath(), context.getInputStreamWrapper(), context.getFileSize(), cacheConf, this.reference, reader);
        }
        return res;
    }

    public void initHFileInfo(ReaderContext context) throws IOException {
        this.hfileInfo = new HFileInfo(context, this.conf);
    }

    int getRefCount() {
        return this.refCount.get();
    }

    int increaseRefCount() {
        return this.refCount.incrementAndGet();
    }

    int decreaseRefCount() {
        return this.refCount.decrementAndGet();
    }

    public static StoreFileInfo createStoreFileInfoForHFile(Configuration conf, FileSystem fs, Path initialPath, boolean primaryReplica) throws IOException {
        if (HFileLink.isHFileLink(initialPath) || StoreFileInfo.isReference(initialPath)) {
            throw new InvalidHFileException("Path " + initialPath + " is a Hfile link or a Regerence");
        }
        StoreFileInfo storeFileInfo = new StoreFileInfo(conf, fs, null, initialPath, primaryReplica, null);
        return storeFileInfo;
    }
}

