/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.regionserver.compactions.CustomTieredCompactor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CustomCellTieringValueProvider
implements CustomTieredCompactor.TieringValueProvider {
    public static final String TIERING_CELL_QUALIFIER = "TIERING_CELL_QUALIFIER";
    private byte[] tieringQualifier;

    @Override
    public void init(Configuration conf) throws Exception {
        this.tieringQualifier = Bytes.toBytes((String)conf.get(TIERING_CELL_QUALIFIER));
    }

    @Override
    public List<Cell> decorateCells(List<Cell> cells) {
        if (this.tieringQualifier != null) {
            byte[] tieringValue = null;
            for (Cell cell : cells) {
                if (!CellUtil.matchingQualifier((Cell)cell, (byte[])this.tieringQualifier)) continue;
                tieringValue = CellUtil.cloneValue((Cell)cell);
                break;
            }
            if (tieringValue == null) {
                tieringValue = Bytes.toBytes((long)Long.MAX_VALUE);
            }
            ArrayBackedTag tieringValueTag = new ArrayBackedTag(9, tieringValue);
            ArrayList<Cell> newCells = new ArrayList<Cell>(cells.size());
            for (Cell cell : cells) {
                List tags = PrivateCellUtil.getTags((Cell)cell);
                tags.add(tieringValueTag);
                newCells.add(PrivateCellUtil.createCell((Cell)cell, (List)tags));
            }
            return newCells;
        }
        return cells;
    }

    @Override
    public long getTieringValue(Cell cell) {
        Optional tagOptional = PrivateCellUtil.getTag((Cell)cell, (byte)9);
        if (tagOptional.isPresent()) {
            Tag tag = (Tag)tagOptional.get();
            return Bytes.toLong((byte[])tag.getValueByteBuffer().array(), (int)tag.getValueOffset(), (int)tag.getValueLength());
        }
        return Long.MAX_VALUE;
    }
}

