/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.RandomKeyValueUtil;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={IOTests.class, LargeTests.class})
public class TestPrefetchPersistence {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPrefetchPersistence.class);
    public TestName name = new TestName();
    @Parameterized.Parameter(value=0)
    public int constructedBlockSize;
    @Parameterized.Parameter(value=1)
    public int[] constructedBlockSizes;
    private static final Logger LOG = LoggerFactory.getLogger(TestPrefetchPersistence.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int NUM_VALID_KEY_TYPES = KeyValue.Type.values().length - 2;
    private static final int DATA_BLOCK_SIZE = 2048;
    private static final int NUM_KV = 1000;
    private Configuration conf;
    private CacheConfig cacheConf;
    private FileSystem fs;
    String prefetchPersistencePath;
    Path testDir;
    BucketCache bucketCache;
    final long capacitySize = 0x2000000L;
    final int writeThreads = 3;
    final int writerQLen = 64;

    @Parameterized.Parameters(name="{index}: blockSize={0}, bucketSizes={1}")
    public static Iterable<Object[]> data() {
        return Arrays.asList(new Object[][]{{16384, new int[]{3072, 5120, 9216, 17408, 29696, 33792, 66560, 99328, 132096}}});
    }

    @Before
    public void setup() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setBoolean("hbase.rs.prefetchblocksonopen", true);
        this.testDir = TEST_UTIL.getDataTestDir();
        TEST_UTIL.getTestFileSystem().mkdirs(this.testDir);
        this.fs = HFileSystem.get((Configuration)this.conf);
    }

    @Test
    public void testPrefetchPersistence() throws Exception {
        this.bucketCache = new BucketCache("file:" + this.testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, this.testDir + "/bucket.persistence", 60000, this.conf);
        this.cacheConf = new CacheConfig(this.conf, (BlockCache)this.bucketCache);
        long usedSize = this.bucketCache.getAllocator().getUsedSize();
        Assert.assertEquals((long)0L, (long)usedSize);
        Assert.assertTrue((boolean)new File(this.testDir + "/bucket.cache").exists());
        Path storeFile = this.writeStoreFile("TestPrefetch0");
        Path storeFile2 = this.writeStoreFile("TestPrefetch1");
        this.readStoreFile(storeFile);
        this.readStoreFile(storeFile2);
        usedSize = this.bucketCache.getAllocator().getUsedSize();
        Assert.assertNotEquals((long)0L, (long)usedSize);
        this.bucketCache.shutdown();
        Assert.assertTrue((boolean)new File(this.testDir + "/bucket.persistence").exists());
        this.bucketCache = new BucketCache("file:" + this.testDir + "/bucket.cache", 0x2000000L, this.constructedBlockSize, this.constructedBlockSizes, 3, 64, this.testDir + "/bucket.persistence", 60000, this.conf);
        this.cacheConf = new CacheConfig(this.conf, (BlockCache)this.bucketCache);
        Assert.assertTrue((usedSize != 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.bucketCache.fullyCachedFiles.containsKey(storeFile.getName()));
        Assert.assertTrue((boolean)this.bucketCache.fullyCachedFiles.containsKey(storeFile2.getName()));
        TEST_UTIL.cleanupTestDir();
    }

    public void readStoreFile(Path storeFilePath) throws Exception {
        HFile.Reader reader = HFile.createReader((FileSystem)this.fs, (Path)storeFilePath, (CacheConfig)this.cacheConf, (boolean)true, (Configuration)this.conf);
        while (!reader.prefetchComplete()) {
            Thread.sleep(1000L);
        }
    }

    public Path writeStoreFile(String fname) throws IOException {
        Path storeFileParentDir = new Path(TEST_UTIL.getDataTestDir(), fname);
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        StoreFileWriter sfw = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withOutputDir(storeFileParentDir).withFileContext(meta).build();
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int rowLen = 32;
        for (int i = 0; i < 1000; ++i) {
            byte[] k = RandomKeyValueUtil.randomOrderedKey(rand, i);
            byte[] v = RandomKeyValueUtil.randomValue(rand);
            int cfLen = ((Random)rand).nextInt(k.length - 32 + 1);
            KeyValue kv = new KeyValue(k, 0, 32, k, 32, cfLen, k, 32 + cfLen, k.length - 32 - cfLen, ((Random)rand).nextLong(), TestPrefetchPersistence.generateKeyType(rand), v, 0, v.length);
            sfw.append((Cell)kv);
        }
        sfw.close();
        return sfw.getPath();
    }

    public static KeyValue.Type generateKeyType(Random rand) {
        if (rand.nextBoolean()) {
            return KeyValue.Type.Put;
        }
        KeyValue.Type keyType = KeyValue.Type.values()[1 + rand.nextInt(NUM_VALID_KEY_TYPES)];
        if (keyType == KeyValue.Type.Minimum || keyType == KeyValue.Type.Maximum) {
            throw new RuntimeException("Generated an invalid key type: " + keyType + ". Probably the layout of KeyValue.Type has changed.");
        }
        return keyType;
    }
}

