/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.SnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.TestSnapshotProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotProcedureEarlyExpiration
extends TestSnapshotProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotProcedureEarlyExpiration.class);

    @Override
    @Before
    public void setup() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        Configuration config = TEST_UTIL.getConfiguration();
        config.setInt("hbase.snapshot.remote.verify.threshold", 1);
        config.setInt("hbase.procedure.remote.dispatcher.delay.msec", 10000);
        config.setInt("hbase.procedure.remote.dispatcher.max.queue.size", 128);
        TEST_UTIL.startMiniCluster(3);
        this.master = TEST_UTIL.getHBaseCluster().getMaster();
        this.TABLE_NAME = TableName.valueOf((byte[])Bytes.toBytes((String)"SPTestTable"));
        this.CF = Bytes.toBytes((String)"cf");
        this.SNAPSHOT_NAME = "SnapshotProcedureTest";
        HashMap<String, Long> properties = new HashMap<String, Long>();
        properties.put("TTL", 1L);
        this.snapshot = new SnapshotDescription(this.SNAPSHOT_NAME, this.TABLE_NAME, SnapshotType.FLUSH, null, -1L, -1, properties);
        this.snapshotProto = ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)this.snapshot);
        this.snapshotProto = SnapshotDescriptionUtils.validate((SnapshotProtos.SnapshotDescription)this.snapshotProto, (Configuration)this.master.getConfiguration());
        byte[][] splitKeys = new RegionSplitter.HexStringSplit().split(10);
        Table table = TEST_UTIL.createTable(this.TABLE_NAME, this.CF, splitKeys);
        TEST_UTIL.loadTable(table, this.CF, false);
    }

    @Test
    public void testSnapshotEarlyExpiration() throws Exception {
        ProcedureExecutor procExec = this.master.getMasterProcedureExecutor();
        MasterProcedureEnv env = (MasterProcedureEnv)procExec.getEnvironment();
        SnapshotProcedure sp = new SnapshotProcedure(env, this.snapshotProto);
        SnapshotProcedure spySp = this.getDelayedOnSpecificStateSnapshotProcedure(sp, (MasterProcedureEnv)procExec.getEnvironment(), MasterProcedureProtos.SnapshotState.SNAPSHOT_COMPLETE_SNAPSHOT);
        long procId = procExec.submitProcedure((Procedure)spySp);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (long)procId);
        Assert.assertTrue((boolean)spySp.isFailed());
        List snapshots = this.master.getSnapshotManager().getCompletedSnapshots();
        Assert.assertEquals((long)0L, (long)snapshots.size());
    }
}

