/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobSubmitted;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobSubmittedEvent
implements HistoryEvent {
    private JobSubmitted datum = new JobSubmitted();
    private JobConf jobConf = null;

    public JobSubmittedEvent(JobID id, String jobName, String userName, long submitTime, String jobConfPath, Map<JobACL, AccessControlList> jobACLs, String jobQueueName) {
        this(id, jobName, userName, submitTime, jobConfPath, jobACLs, jobQueueName, "", "", "", "");
    }

    public JobSubmittedEvent(JobID id, String jobName, String userName, long submitTime, String jobConfPath, Map<JobACL, AccessControlList> jobACLs, String jobQueueName, String workflowId, String workflowName, String workflowNodeName, String workflowAdjacencies) {
        this(id, jobName, userName, submitTime, jobConfPath, jobACLs, jobQueueName, workflowId, workflowName, workflowNodeName, workflowAdjacencies, "");
    }

    public JobSubmittedEvent(JobID id, String jobName, String userName, long submitTime, String jobConfPath, Map<JobACL, AccessControlList> jobACLs, String jobQueueName, String workflowId, String workflowName, String workflowNodeName, String workflowAdjacencies, String workflowTags) {
        this(id, jobName, userName, submitTime, jobConfPath, jobACLs, jobQueueName, workflowId, workflowName, workflowNodeName, workflowAdjacencies, workflowTags, null);
    }

    public JobSubmittedEvent(JobID id, String jobName, String userName, long submitTime, String jobConfPath, Map<JobACL, AccessControlList> jobACLs, String jobQueueName, String workflowId, String workflowName, String workflowNodeName, String workflowAdjacencies, String workflowTags, JobConf conf) {
        this.datum.setJobid((CharSequence)new Utf8(id.toString()));
        this.datum.setJobName((CharSequence)new Utf8(jobName));
        this.datum.setUserName((CharSequence)new Utf8(userName));
        this.datum.setSubmitTime(submitTime);
        this.datum.setJobConfPath((CharSequence)new Utf8(jobConfPath));
        HashMap<CharSequence, CharSequence> jobAcls = new HashMap<CharSequence, CharSequence>();
        for (Map.Entry<JobACL, AccessControlList> entry : jobACLs.entrySet()) {
            jobAcls.put((CharSequence)new Utf8(entry.getKey().getAclName()), (CharSequence)new Utf8(entry.getValue().getAclString()));
        }
        this.datum.setAcls(jobAcls);
        if (jobQueueName != null) {
            this.datum.setJobQueueName((CharSequence)new Utf8(jobQueueName));
        }
        if (workflowId != null) {
            this.datum.setWorkflowId((CharSequence)new Utf8(workflowId));
        }
        if (workflowName != null) {
            this.datum.setWorkflowName((CharSequence)new Utf8(workflowName));
        }
        if (workflowNodeName != null) {
            this.datum.setWorkflowNodeName((CharSequence)new Utf8(workflowNodeName));
        }
        if (workflowAdjacencies != null) {
            this.datum.setWorkflowAdjacencies((CharSequence)new Utf8(workflowAdjacencies));
        }
        if (workflowTags != null) {
            this.datum.setWorkflowTags((CharSequence)new Utf8(workflowTags));
        }
        this.jobConf = conf;
    }

    JobSubmittedEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobSubmitted)((Object)datum);
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.getJobid().toString());
    }

    public String getJobName() {
        return this.datum.getJobName().toString();
    }

    public String getJobQueueName() {
        if (this.datum.getJobQueueName() != null) {
            return this.datum.getJobQueueName().toString();
        }
        return null;
    }

    public String getUserName() {
        return this.datum.getUserName().toString();
    }

    public long getSubmitTime() {
        return this.datum.getSubmitTime();
    }

    public String getJobConfPath() {
        return this.datum.getJobConfPath().toString();
    }

    public Map<JobACL, AccessControlList> getJobAcls() {
        HashMap<JobACL, AccessControlList> jobAcls = new HashMap<JobACL, AccessControlList>();
        for (JobACL jobACL : JobACL.values()) {
            Utf8 jobACLsUtf8 = new Utf8(jobACL.getAclName());
            if (!this.datum.getAcls().containsKey(jobACLsUtf8)) continue;
            jobAcls.put(jobACL, new AccessControlList(this.datum.getAcls().get(jobACLsUtf8).toString()));
        }
        return jobAcls;
    }

    public String getWorkflowId() {
        if (this.datum.getWorkflowId() != null) {
            return this.datum.getWorkflowId().toString();
        }
        return null;
    }

    public String getWorkflowName() {
        if (this.datum.getWorkflowName() != null) {
            return this.datum.getWorkflowName().toString();
        }
        return null;
    }

    public String getWorkflowNodeName() {
        if (this.datum.getWorkflowNodeName() != null) {
            return this.datum.getWorkflowNodeName().toString();
        }
        return null;
    }

    public String getWorkflowAdjacencies() {
        if (this.datum.getWorkflowAdjacencies() != null) {
            return this.datum.getWorkflowAdjacencies().toString();
        }
        return null;
    }

    public String getWorkflowTags() {
        if (this.datum.getWorkflowTags() != null) {
            return this.datum.getWorkflowTags().toString();
        }
        return null;
    }

    @Override
    public EventType getEventType() {
        return EventType.JOB_SUBMITTED;
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase((String)this.getEventType().name()));
        tEvent.addInfo("SUBMIT_TIME", (Object)this.getSubmitTime());
        tEvent.addInfo("QUEUE_NAME", (Object)this.getJobQueueName());
        tEvent.addInfo("JOB_NAME", (Object)this.getJobName());
        tEvent.addInfo("USER_NAME", (Object)this.getUserName());
        tEvent.addInfo("JOB_CONF_PATH", (Object)this.getJobConfPath());
        tEvent.addInfo("ACLS", this.getJobAcls());
        tEvent.addInfo("JOB_QUEUE_NAME", (Object)this.getJobQueueName());
        tEvent.addInfo("WORKLFOW_ID", (Object)this.getWorkflowId());
        tEvent.addInfo("WORKFLOW_NAME", (Object)this.getWorkflowName());
        tEvent.addInfo("WORKFLOW_NODE_NAME", (Object)this.getWorkflowNodeName());
        tEvent.addInfo("WORKFLOW_ADJACENCIES", (Object)this.getWorkflowAdjacencies());
        tEvent.addInfo("WORKFLOW_TAGS", (Object)this.getWorkflowTags());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

