/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.io.encoding.IndexBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockIndexChunk;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileIndexBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileInfo;
import org.apache.hadoop.hbase.io.hfile.NoOpIndexBlockEncoder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HFileIndexBlockEncoderImpl
implements HFileIndexBlockEncoder {
    private final IndexBlockEncoding indexBlockEncoding;

    public HFileIndexBlockEncoderImpl(IndexBlockEncoding encoding) {
        this.indexBlockEncoding = encoding != null ? encoding : IndexBlockEncoding.NONE;
    }

    public static HFileIndexBlockEncoder createFromFileInfo(HFileInfo fileInfo) throws IOException {
        IndexBlockEncoding encoding = IndexBlockEncoding.NONE;
        byte[] dataBlockEncodingType = fileInfo.get(INDEX_BLOCK_ENCODING);
        if (dataBlockEncodingType != null) {
            String dataBlockEncodingStr = Bytes.toString(dataBlockEncodingType);
            try {
                encoding = IndexBlockEncoding.valueOf(dataBlockEncodingStr);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Invalid data block encoding type in file info: " + dataBlockEncodingStr, ex);
            }
        }
        if (encoding == IndexBlockEncoding.NONE) {
            return NoOpIndexBlockEncoder.INSTANCE;
        }
        return new HFileIndexBlockEncoderImpl(encoding);
    }

    @Override
    public void saveMetadata(HFile.Writer writer) throws IOException {
        writer.appendFileInfo(INDEX_BLOCK_ENCODING, this.indexBlockEncoding.getNameInBytes());
    }

    @Override
    public IndexBlockEncoding getIndexBlockEncoding() {
        return this.indexBlockEncoding;
    }

    @Override
    public void encode(BlockIndexChunk blockIndexChunk, boolean rootIndexBlock, DataOutput out) throws IOException {
    }

    @Override
    public HFileIndexBlockEncoder.EncodedSeeker createSeeker() {
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(indexBlockEncoding=" + (Object)((Object)this.indexBlockEncoding) + ")";
    }
}

