/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestParallelReadUtil;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;

public class TestParallelShortCircuitReadUnCached
extends TestParallelReadUtil {
    private static TemporarySocketDirectory sockDir;

    @BeforeClass
    public static void setupCluster() throws Exception {
        if (DomainSocket.getLoadingFailureReason() != null) {
            return;
        }
        sockDir = new TemporarySocketDirectory();
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestParallelShortCircuitReadUnCached._PORT.sock").getAbsolutePath());
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        conf.setBoolean("dfs.encrypt.data.transfer", true);
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", false);
        conf.setBoolean("dfs.client.domain.socket.data.traffic", true);
        conf.setInt("dfs.datanode.socket.reuse.keepalive", 1);
        conf.setLong("dfs.client.socketcache.expiryMsec", 300000L);
        conf.setInt("dfs.client.socketcache.capacity", 32);
        conf.setInt("dfs.client.read.shortcircuit.streams.cache.size", 0);
        DomainSocket.disableBindPathValidation();
        DFSInputStream.tcpReadsDisabledForTesting = true;
        TestParallelShortCircuitReadUnCached.setupCluster(1, conf);
    }

    @Before
    public void before() {
        Assume.assumeThat((Object)DomainSocket.getLoadingFailureReason(), (Matcher)CoreMatchers.equalTo(null));
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        if (DomainSocket.getLoadingFailureReason() != null) {
            return;
        }
        sockDir.close();
        TestParallelReadUtil.teardownCluster();
    }
}

