/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestCustomWALCellCodec {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCustomWALCellCodec.class);

    @Test
    public void testCreatePreparesCodec() throws Exception {
        Configuration conf = new Configuration(false);
        conf.setClass("hbase.regionserver.wal.codec", CustomWALCellCodec.class, WALCellCodec.class);
        CustomWALCellCodec codec = (CustomWALCellCodec)WALCellCodec.create((Configuration)conf, null, null);
        Assert.assertEquals((String)"Custom codec didn't get initialized with the right configuration!", (Object)conf, (Object)codec.conf);
        Assert.assertEquals((String)"Custom codec didn't get initialized with the right compression context!", null, (Object)codec.context);
    }

    @Test(expected=RuntimeException.class)
    public void testCreatePreparesCodecInvalidClass() throws Exception {
        Configuration conf = new Configuration(false);
        conf.setStrings("hbase.regionserver.wal.codec", new String[]{"org.apache.hbase.wal.NoSuchClass"});
        WALCellCodec.create((Configuration)conf, null, null);
    }

    public static class CustomWALCellCodec
    extends WALCellCodec {
        public Configuration conf;
        public CompressionContext context;

        public CustomWALCellCodec(Configuration conf, CompressionContext compression) {
            super(conf, compression);
            this.conf = conf;
            this.context = compression;
        }
    }
}

