/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.records;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class SubClusterInfo {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static SubClusterInfo newInstance(SubClusterId subClusterId, String amRMServiceAddress, String clientRMServiceAddress, String rmAdminServiceAddress, String rmWebServiceAddress, SubClusterState state, long lastStartTime, String capability) {
        return SubClusterInfo.newInstance(subClusterId, amRMServiceAddress, clientRMServiceAddress, rmAdminServiceAddress, rmWebServiceAddress, 0L, state, lastStartTime, capability);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static SubClusterInfo newInstance(SubClusterId subClusterId, String amRMServiceAddress, String clientRMServiceAddress, String rmAdminServiceAddress, String rmWebServiceAddress, long lastHeartBeat, SubClusterState state, long lastStartTime, String capability) {
        SubClusterInfo subClusterInfo = (SubClusterInfo)Records.newRecord(SubClusterInfo.class);
        subClusterInfo.setSubClusterId(subClusterId);
        subClusterInfo.setAMRMServiceAddress(amRMServiceAddress);
        subClusterInfo.setClientRMServiceAddress(clientRMServiceAddress);
        subClusterInfo.setRMAdminServiceAddress(rmAdminServiceAddress);
        subClusterInfo.setRMWebServiceAddress(rmWebServiceAddress);
        subClusterInfo.setLastHeartBeat(lastHeartBeat);
        subClusterInfo.setState(state);
        subClusterInfo.setLastStartTime(lastStartTime);
        subClusterInfo.setCapability(capability);
        return subClusterInfo;
    }

    public static SubClusterInfo newInstance(SubClusterId subClusterId, String rmWebServiceAddress, SubClusterState state, long lastStartTime, long lastHeartBeat, String capability) {
        return SubClusterInfo.newInstance(subClusterId, null, null, null, rmWebServiceAddress, lastHeartBeat, state, lastStartTime, capability);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract SubClusterId getSubClusterId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setSubClusterId(SubClusterId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getAMRMServiceAddress();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setAMRMServiceAddress(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getClientRMServiceAddress();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setClientRMServiceAddress(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getRMAdminServiceAddress();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setRMAdminServiceAddress(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getRMWebServiceAddress();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setRMWebServiceAddress(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getLastHeartBeat();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setLastHeartBeat(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract SubClusterState getState();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setState(SubClusterState var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getLastStartTime();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setLastStartTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getCapability();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCapability(String var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SubClusterInfo: [").append("SubClusterId: ").append(this.getSubClusterId()).append(", ").append("AMRMServiceAddress: ").append(this.getAMRMServiceAddress()).append(", ").append("ClientRMServiceAddress: ").append(this.getClientRMServiceAddress()).append(", ").append("RMAdminServiceAddress: ").append(this.getRMAdminServiceAddress()).append(", ").append("RMWebServiceAddress: ").append(this.getRMWebServiceAddress()).append(", ").append("State: ").append((Object)this.getState()).append(", ").append("LastStartTime: ").append(this.getLastStartTime()).append(", ").append("Capability: ").append(this.getCapability()).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj instanceof SubClusterInfo) {
            SubClusterInfo other = (SubClusterInfo)obj;
            return new EqualsBuilder().append((Object)this.getSubClusterId(), (Object)other.getSubClusterId()).append((Object)this.getAMRMServiceAddress(), (Object)other.getAMRMServiceAddress()).append((Object)this.getClientRMServiceAddress(), (Object)other.getClientRMServiceAddress()).append((Object)this.getRMAdminServiceAddress(), (Object)other.getRMAdminServiceAddress()).append((Object)this.getRMWebServiceAddress(), (Object)other.getRMWebServiceAddress()).append((Object)this.getState(), (Object)other.getState()).append(this.getLastStartTime(), other.getLastStartTime()).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getSubClusterId()).append((Object)this.getAMRMServiceAddress()).append((Object)this.getClientRMServiceAddress()).append((Object)this.getRMAdminServiceAddress()).append((Object)this.getRMWebServiceAddress()).append((Object)this.getState()).append(this.getLastStartTime()).toHashCode();
    }
}

