/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapacityQueueACLsManager
extends QueueACLsManager {
    private static final Logger LOG = LoggerFactory.getLogger(CapacityQueueACLsManager.class);

    public CapacityQueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
        super(scheduler, conf);
    }

    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, RMApp app, String remoteAddress, List<String> forwardedAddresses) {
        if (!this.isACLsEnable) {
            return true;
        }
        CSQueue queue = ((CapacityScheduler)this.scheduler).getQueue(app.getQueue());
        if (queue == null) {
            if (((CapacityScheduler)this.scheduler).isAmbiguous(app.getQueue())) {
                LOG.error("Queue " + app.getQueue() + " is ambiguous for " + app.getApplicationId());
                return false;
            }
            LOG.error("Queue " + app.getQueue() + " does not exist for " + app.getApplicationId());
            return true;
        }
        return this.authorizer.checkPermission(new AccessRequest(queue.getPrivilegedEntity(), callerUGI, SchedulerUtils.toAccessType(acl), app.getApplicationId().toString(), app.getName(), remoteAddress, forwardedAddresses));
    }

    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, RMApp app, String remoteAddress, List<String> forwardedAddresses, String targetQueue) {
        if (!this.isACLsEnable) {
            return true;
        }
        CapacityScheduler cs = (CapacityScheduler)this.scheduler;
        CSQueue queue = cs.getQueue(targetQueue);
        if (queue == null) {
            LOG.warn("Target queue " + targetQueue + (cs.isAmbiguous(targetQueue) ? " is ambiguous while trying to move " : " does not exist while trying to move ") + app.getApplicationId());
            return false;
        }
        return this.authorizer.checkPermission(new AccessRequest(queue.getPrivilegedEntity(), callerUGI, SchedulerUtils.toAccessType(acl), app.getApplicationId().toString(), app.getName(), remoteAddress, forwardedAddresses));
    }
}

