/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;

@Schema(description="LLM Model Provider configuration")
public class ModelProviderConfig {
    @Schema(title="Model type, text-generate, vision")
    private String type;
    @Schema(title="Model Provider code, like openai, zai, bigmodel")
    private String code;
    @Schema(title="custom the provider server base url")
    private String baseUrl;
    @Schema(title="use the model id name, eg: gpt-5, glm-4.6")
    private String model;
    @Schema(title="API Key", description="API key", example="sk-...")
    @NotBlank(message="API Key cannot be empty when enabled")
    private @NotBlank(message="API Key cannot be empty when enabled") String apiKey;

    public String getType() {
        return this.type;
    }

    public String getCode() {
        return this.code;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getModel() {
        return this.model;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelProviderConfig)) {
            return false;
        }
        ModelProviderConfig other = (ModelProviderConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        return !(this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelProviderConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        return result;
    }

    public String toString() {
        return "ModelProviderConfig(type=" + this.getType() + ", code=" + this.getCode() + ", baseUrl=" + this.getBaseUrl() + ", model=" + this.getModel() + ", apiKey=" + this.getApiKey() + ")";
    }

    public ModelProviderConfig(String type, String code, String baseUrl, String model, String apiKey) {
        this.type = type;
        this.code = code;
        this.baseUrl = baseUrl;
        this.model = model;
        this.apiKey = apiKey;
    }

    public ModelProviderConfig() {
    }
}

