/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.entrance.processor;

import com.google.protobuf.ByteString;
import io.netty.channel.ChannelHandlerContext;
import org.apache.hertzbeat.collector.timer.TimerDispatch;
import org.apache.hertzbeat.common.entity.dto.ServerInfo;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.support.SpringContextHolder;
import org.apache.hertzbeat.common.util.AesUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.remoting.netty.NettyRemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoOnlineProcessor
implements NettyRemotingProcessor {
    private static final Logger log = LoggerFactory.getLogger(GoOnlineProcessor.class);
    private TimerDispatch timerDispatch;

    public ClusterMsg.Message handle(ChannelHandlerContext ctx, ClusterMsg.Message message) {
        if (this.timerDispatch == null) {
            this.timerDispatch = (TimerDispatch)SpringContextHolder.getBean(TimerDispatch.class);
        }
        if (message.getMsg().isEmpty()) {
            log.warn("The message that server response to collector is empty, please upgrade server");
        } else {
            ServerInfo serverInfo = (ServerInfo)JsonUtil.fromJson((String)message.getMsg().toStringUtf8(), ServerInfo.class);
            if (serverInfo == null || serverInfo.getAesSecret() == null) {
                log.warn("The message that server response to collector has not secret empty, please check");
            } else {
                AesUtil.setDefaultSecretKey((String)serverInfo.getAesSecret());
            }
        }
        if (ClusterMsg.Direction.REQUEST.equals((Object)message.getDirection())) {
            this.timerDispatch.goOnline();
        }
        log.info("receive online message and handle success");
        return ClusterMsg.Message.newBuilder().setIdentity(message.getIdentity()).setDirection(ClusterMsg.Direction.RESPONSE).setMsg(ByteString.copyFromUtf8((String)String.valueOf(0))).build();
    }
}

