/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.spi.messages;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.plc4x.java.api.exceptions.PlcNotImplementedException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.model.PlcSubscriptionTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DefaultPlcSubscriptionResponse
implements PlcSubscriptionResponse,
PlcResponse,
Serializable {
    private final PlcSubscriptionRequest request;
    private final Map<String, ResponseItem<PlcSubscriptionHandle>> values;

    public DefaultPlcSubscriptionResponse(PlcSubscriptionRequest request, Map<String, ResponseItem<PlcSubscriptionHandle>> values) {
        this.request = request;
        this.values = values;
        request.getPreRegisteredConsumers().forEach((subscriptionTagName, consumers) -> {
            PlcSubscriptionHandle subscriptionHandle = this.getSubscriptionHandle((String)subscriptionTagName);
            if (subscriptionHandle == null) {
                throw new PlcRuntimeException("PlcSubscriptionHandle for " + subscriptionTagName + " not found");
            }
            consumers.forEach(arg_0 -> ((PlcSubscriptionHandle)subscriptionHandle).register(arg_0));
        });
    }

    public PlcSubscriptionHandle getSubscriptionHandle(String name) {
        ResponseItem<PlcSubscriptionHandle> response = this.values.get(name);
        if (response == null) {
            return null;
        }
        if (response.getCode() != PlcResponseCode.OK) {
            throw new PlcRuntimeException("Item " + name + " failed to subscribe: " + response.getCode());
        }
        return response.getValue();
    }

    public Collection<String> getTagNames() {
        return this.values.keySet();
    }

    public PlcSubscriptionTag getTag(String name) {
        throw new PlcNotImplementedException("tag access not possible as these come async");
    }

    public PlcResponseCode getResponseCode(String name) {
        ResponseItem<PlcSubscriptionHandle> response = this.values.get(name);
        if (response == null) {
            return null;
        }
        return response.getCode();
    }

    public PlcSubscriptionRequest getRequest() {
        return this.request;
    }

    public Collection<PlcSubscriptionHandle> getSubscriptionHandles() {
        return this.values.values().stream().map(ResponseItem::getValue).collect(Collectors.toList());
    }

    public Map<String, ResponseItem<PlcSubscriptionHandle>> getValues() {
        return this.values;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext("PlcSubscriptionResponse", new WithWriterArgs[0]);
        if (this.request instanceof Serializable) {
            ((Serializable)this.request).serialize(writeBuffer);
        }
        writeBuffer.pushContext("values", new WithWriterArgs[0]);
        for (Map.Entry<String, ResponseItem<PlcSubscriptionHandle>> valueEntry : this.values.entrySet()) {
            String tagName = valueEntry.getKey();
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
            ResponseItem<PlcSubscriptionHandle> valueResponse = valueEntry.getValue();
            valueResponse.serialize(writeBuffer);
            writeBuffer.pushContext(tagName, new WithWriterArgs[0]);
        }
        writeBuffer.popContext("values", new WithWriterArgs[0]);
        writeBuffer.popContext("PlcSubscriptionResponse", new WithWriterArgs[0]);
    }
}

